package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.loopnode;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;

import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;

public class LoopNodeContentNodesRule extends ValidationRule<LoopNode>{

	@Override
	public List<ValidationMessage> validateRule(LoopNode target) {
		List<ValidationMessage> messages = new ArrayList<ValidationMessage>();
		
		List<NodeElement> rootNodes = getRootNodes(target);
		if(rootNodes.size() > 1){
		    ValidationMessageAdder.getInstance().addValidationMessage(messages, target, ValidationMessageCode.LOOPNODE_MORE_THAN_ONE_ROOT);
		}
		
		return messages;
	}
	
	private List<NodeElement> getRootNodes(LoopNode loopNode){
		NodeElement[] nodes = loopNode.getNodeElements();
		List<NodeElement> rootNodes = new ArrayList<NodeElement>();
		List<String> targets = new ArrayList<String>();
		for (NodeElement nodeElement : nodes) {
			for (Transition transition : nodeElement.getTransitions()) {
				String nodeName = transition.getTo();
				targets.add(nodeName);
			}
		}
		for (NodeElement nodeElement : nodes) {
			if(!targets.contains(nodeElement.getName())){
				rootNodes.add(nodeElement);
			}
		}
		
		return rootNodes;
	}
	
}
