/*
 * Created on Nov 8, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.startstate;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.Controller;
import org.jbpm.gd.jpdl.model.StartState;
import org.jbpm.gd.jpdl.model.Task;
import org.jbpm.gd.jpdl.model.Variable;

import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesRule;

/**
 * Validates all the variables in the Start State, ensuring that the required fields are present.
 * 
 * @author Vijay Silva
 */
public class VariablesRule extends NodeVariablesRule<StartState>
{
	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesRule#getVariables(org.jbpm.gd.jpdl.model.NodeElement)
	 */
	@Override
	protected List<Variable> getVariables(StartState node)
	{
		List<Variable> variables = new ArrayList<Variable>();

		Task task = node.getTask();
		Controller controller = (task != null) ? task.getController() : null;
		Variable[] nodeVariables = (controller != null) ? controller.getVariables() : null;
		if (nodeVariables != null)
			for (Variable variable : nodeVariables)
				variables.add(variable);

		return variables;
	}

	/**
	 * Do not validate each variable for a blank name, use group validation instead.
	 * 
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesRule#isValidatingNameBlank(org.jbpm.gd.jpdl.model.NodeElement)
	 */
	@Override
	protected boolean isValidatingNameBlank(StartState node)
	{
		return false;
	}

	/**
	 * Do not validate each variable for a blank mapped name, use group validation instead.
	 * 
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesRule#isValidatingMappedNameBlank(org.jbpm.gd.jpdl.model.NodeElement)
	 */
	@Override
	protected boolean isValidatingMappedNameBlank(StartState node)
	{
		return false;
	}
}
