/*
 * Created on Oct 27, 2008 (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.debugger.core.graph;

import java.util.Date;

import org.jbpm.context.exe.JbpmTypeMatcher;

/**
 * JBPM Type matcher for variables to determine if the variable is a Date
 * 
 * @author Vijay Silva
 */
public class DateTypeMatcher2 implements JbpmTypeMatcher {

	/* Serialization UID */
	private static final long serialVersionUID = -7444244116722537972L;

	/**
	 * Evaluates if the input can be cast to a java.util.Date object.
	 * 
	 * @see org.jbpm.context.exe.JbpmTypeMatcher#matches(java.lang.Class)
	 */
	public boolean matches(@SuppressWarnings("rawtypes") Class clazz) {
		if (clazz == null)
			return false;

		return Date.class.isAssignableFrom(clazz);
	}
}
