/**
 * ExtendedDecision.java
 * Created Nov 4, 2008
 * Copyright (c) Tandberg Television 2008
 */
package com.tandbergtv.watchpoint.studio.debugger.core.graph;

import java.util.Collection;

import org.dom4j.Element;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.node.Decision;
import org.jbpm.jpdl.xml.JpdlXmlReader;

/**
 * Extends JBPM Decision node's behavior
 * 
 * @author Sahil Verma
 */
public class Decision2 extends Decision {

	private static final long serialVersionUID = 1703129440822289397L;

	protected String decisionExpression;
	
	/**
	 * Creates an {@link Decision2}
	 */
	public Decision2() {
	}

	/**
	 * Creates an {@link Decision2}
	 * 
	 * @param name
	 */
	public Decision2(String name) {
		super(name);
	}

	@SuppressWarnings("unchecked")
	public Transition getLeavingTransition(String transitionName) {
		for (Transition transition : (Collection<Transition>)getLeavingTransitions()) {
			if (transition.getName().equals(transitionName)) {
				return transition;
			}
		}
		
		return null;
	}
	
	@Override
	public void read(Element decisionElement, JpdlXmlReader jpdlReader) {
		super.read(decisionElement, jpdlReader);
		decisionExpression = decisionElement.attributeValue("expression");

	}
	public String getDecisionExpression() {
		return decisionExpression;
	}
}
