package com.tandbergtv.watchpoint.studio.debugger.model;

import static com.tandbergtv.watchpoint.studio.debugger.launching.TemplateLauncherConstants.TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_DATA_VARIABLES;

import java.util.HashMap;
import java.util.Map;

import com.tandbergtv.watchpoint.studio.debugger.launching.TemplateLauncherConstants;

/**
 * 		Data persisted for Parameterizable nodes.
 * 
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class ParameterizableSimulationData extends SimulationData {

	@SuppressWarnings("rawtypes")
	public ParameterizableSimulationData(Map simulationAttributes) {
		super(simulationAttributes);
	}
	
	public ParameterizableSimulationData() {
		super();
	}
	
	public ParameterizableSimulationData(SimulationData simulationData) {
		this(simulationData.simulationAttributes);
	}
	
	public Object getVariable(String variableName) {
		String key = TemplateLauncherConstants.TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_DATA_VARIABLES
        		+ "." + variableName;

		return simulationAttributes.get(key);
	}
	
	public Map<String, Object> getVariables() {
		Map<String, Object> map = new HashMap<String, Object>();
		
		for (Object obj : simulationAttributes.keySet()) {
			String key = 
				obj.toString().replaceFirst(TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_DATA_VARIABLES + ".", "");
			
			map.put(key, simulationAttributes.get(obj.toString()));
		}
		
		return map;
	}
	
	public boolean hasVariable(String variableName) {
		String key = TemplateLauncherConstants.TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_DATA_VARIABLES
        		+ "." + variableName;

		return simulationAttributes.containsKey(key);
	}
	
	@SuppressWarnings("unchecked")
	public Object setVariable(String variableName, Object value) {
		String key = TemplateLauncherConstants.TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_DATA_VARIABLES
		              + "." + variableName;
		return simulationAttributes.put(key, value);
	}
	
	@SuppressWarnings("unchecked")
	public Object setFail(boolean fail) {
		String key = TemplateLauncherConstants.TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_DATA_FAIL;
		return simulationAttributes.put(key, fail);
	}
	
	public boolean isFail() {
		String key = TemplateLauncherConstants.TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_DATA_FAIL;
		String failStr = (String) simulationAttributes.get(key);
		boolean isFail = false;
		if (failStr != null && !failStr.trim().isEmpty()) {
			isFail = Boolean.valueOf(failStr);
		}
		return isFail;
	}


}
