/**
 * Lifecycle.java
 * Created Aug 23, 2012
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.exe;

import static com.tandbergtv.watchpoint.studio.debugger.runtime.Services.addService;
import static com.tandbergtv.watchpoint.studio.debugger.runtime.Services.removeService;
import static com.tandbergtv.workflow.driver.service.IProcessManagerService.DRIVER_HALTED_PROPERTY;
import static com.tandbergtv.workflow.driver.service.IProcessManagerService.LOG_LEVEL;
import static com.tandbergtv.workflow.driver.service.IProcessManagerService.NO_RETRY_ON_RECOVERY;
import static com.tandbergtv.workflow.driver.service.IProcessManagerService.POOL_SIZE;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import java.util.UUID;

import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;

import com.hazelcast.config.Config;
import com.hazelcast.core.Hazelcast;
import com.tandbergtv.watchpoint.studio.debugger.runtime.hibernate.HibernateUtil;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.LogLevel;
import com.tandbergtv.workflow.core.WorkflowProcess;
import com.tandbergtv.workflow.core.service.internal.CompositeCache;
import com.tandbergtv.workflow.core.service.internal.DistributedScheduler;
import com.tandbergtv.workflow.core.service.internal.RecoverableDistributedScheduler;
import com.tandbergtv.workflow.core.service.internal.ServiceLifecycleListener;
import com.tandbergtv.workflow.driver.internal.HibernatePersistenceService;
import com.tandbergtv.workflow.driver.internal.ProcessManager;
import com.tandbergtv.workflow.driver.service.IPersistenceService;
import com.tandbergtv.workflow.driver.service.IProcessManagerService;
import com.tandbergtv.workflow.driver.service.ITemplateLoaderService;
import com.tandbergtv.workflow.driver.template.TemplateLoaderService;

/**
 * Runtime lifecycle
 * 
 * @author Sahil Verma
 */
public class Lifecycle {
	
	private static final Logger logger = Logger.getLogger(Lifecycle.class);
	
	public static void start() {
		startHazelcast();
		
		HibernateUtil.initialize();
		SessionFactory factory = HibernateUtil.getSessionFactory();

		ServiceLifecycleListener listener = new ServiceLifecycleListener();

		addService(listener);
		addService(new CompositeCache<WorkflowProcess>("Process Cache", 64));

		Properties properties = new Properties();
		
		properties.setProperty("template.max.count", "64"); //To include subprocesses
		
		addService(new TemplateLoaderService(properties, factory));
		addService(new RecoverableDistributedScheduler<CustomToken>("distributed-scheduler", 1));
		addService(new DistributedScheduler<CustomToken>("one-shot-distributed-scheduler", 1));
		addService(new HibernatePersistenceService(factory));
		addService(new ProcessManager(getProperties()));
	}
	
	public static void stop() {
		removeService(IPersistenceService.class);
		removeService(IProcessManagerService.class);
		removeService("Process Cache");
		removeService(ITemplateLoaderService.class);
		removeService("one-shot-distributed-scheduler");
		removeService("distributed-scheduler");
		removeService(ServiceLifecycleListener.class);

		HibernateUtil.close();
		Hazelcast.getLifecycleService().shutdown();
		Hazelcast.shutdownAll();

		try {
			DriverManager.getConnection("jdbc:derby:;shutdown=true");
		} catch (SQLException e) {
			int code = e.getErrorCode();
			String state = e.getSQLState();

			if (!(code == 50000 && "XJ015".equals(state)))
				logger.error("Database didn't die :(, code=" + code + " state=" + state, e);
		}
	}
	
	private static void startHazelcast() {
		System.setProperty("hazelcast.logging.type", "log4j");
		Config config = new Config();

		/* Ensure that no VMs on this host form a cluster */
		config.getGroupConfig().setPassword(UUID.randomUUID().toString());
        
        Hazelcast.init(config);
	}
	
	private static Properties getProperties() {
		Properties properties = new Properties();

		properties.setProperty(DRIVER_HALTED_PROPERTY, "false");
		properties.setProperty(NO_RETRY_ON_RECOVERY, "false");
		properties.setProperty(LOG_LEVEL, LogLevel.DEBUG.toString()); //FIXME OFF?
		properties.setProperty(POOL_SIZE, "2"); //FIXME Why this number?

		return properties;
	}
}
