package com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import org.jbpm.context.def.VariableAccess;

import bsh.EvalError;
import bsh.Interpreter;

import com.tandbergtv.watchpoint.studio.debugger.model.ParameterizableSimulationData;
import com.tandbergtv.watchpoint.studio.debugger.runtime.exception.NodeSimulationException;

public abstract class AbstractMessageNodeSimulator extends NodeSimulator {

	@Override
	public void simulate() throws Exception {
		
		Map<String, Object> variableValues = new HashMap<String, Object>();
		for (VariableAccess var : getVariables()) {
			// will only simulate writable variables
			if (var.getAccess().isWritable()) {
				String script = (String) getSimulationData().getVariable(var.getVariableName());
				// if the script is null or is not configured, skip this variable simulation.
				// variable will keep its previous value.
				if (script != null && !script.trim().isEmpty()) {
					Object result = executeScript(var, script);
		
					if (result == null) {
						// couldn't execute the script, assume its a fixed value
						result = getSimulationData().getVariable(var.getVariableName());
					}
					if (result != null) {
						variableValues.put(var.getVariableName(), result);
					}
				}
			}
		}
		for (String varName : variableValues.keySet()) {
			executionContext.setVariable(varName, variableValues.get(varName));			
		}
	}
	
	protected Object executeScript(VariableAccess simulatingVar, String script) throws Exception {
		Object result = null;
		Interpreter i = new Interpreter();  // Construct an interpreter

		// put all the template variables in the interpreter context.
		Map<?, ?> templateVariables = executionContext.getContextInstance().getVariables(executionContext.getToken());
		for (Object varName : templateVariables.keySet()) {
			i.set(varName.toString(), templateVariables.get(varName));
		}
		
		// put the node variables in the interpreter context 
		Collection<VariableAccess> nodeVariables = getVariables();
		for (VariableAccess nodeVar : nodeVariables) {
			// resolves the variable script
			i.set(nodeVar.getMappedName(), executionContext.getVariable(nodeVar.getVariableName()));
		}
		
		try {
			result = i.eval(script.toString());
			if (result == null) {
				result = i.get(simulatingVar.getMappedName());
			}
		} catch (EvalError error) {
			String message = " Error evaluating the expression configured for the variable: " + simulatingVar.getMappedName()
				           + ". Expression: " + script + ". Implicit objects: ";
			for (VariableAccess var : getVariables()) {
				message+= var.getMappedName() + "=" + executionContext.getVariable(var.getVariableName()) + " ";
			}
			throw new NodeSimulationException(message, node, this, error);
		}
	
		return result;
	}
	
	public ParameterizableSimulationData getSimulationData() {
		ParameterizableSimulationData result = null;
		if (simulationConfig.getSimulationData() instanceof ParameterizableSimulationData) {
			result = (ParameterizableSimulationData) simulationConfig.getSimulationData();
		} else {
			if (simulationConfig.getSimulationData() != null) {
				result = new ParameterizableSimulationData(simulationConfig.getSimulationData());
			}
		}
		simulationConfig.setSimulationData(result);
		return result;
	}

	@Override
	public boolean fail() {
		boolean configuredToFail = false;
		if (getSimulationData() != null) {
			configuredToFail = getSimulationData().isFail();
		}
		return super.fail() || configuredToFail;
	}

}