package com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation;

import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.def.Transition;

import com.tandbergtv.workflow.core.MailNode;

/**
 * 		
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class MailNodeSimulator extends NodeSimulator {

	protected List<Transition> leavingTransitions = null;
	
	protected String to;
	private String subject;
	private String text;
	private String attachment;
	
	
	@Override
	public void simulate() {
		MailNode mail = (MailNode) node;
		to = evaluate(mail.getTo());
		subject = evaluate(mail.getSubject());
		text = evaluate(mail.getText());
		attachment = evaluate(mail.getAttachment());
	}
	
	protected String evaluate(String expression) {
		Object result = expression;
		
		if (expression != null && !expression.trim().isEmpty()) {
			try {
				result = executionContext.getVariable(expression);
			} catch (Exception error) {
					// Not a expression. Will consider it as static text."
			}
		}
		
		String resultStr = null;
		if (result != null) {
			resultStr = result.toString();
		} else {
			resultStr = expression;
		}
		return resultStr;
	}
	
	@Override
	public boolean fail() {
		return false;
	}
	
	@Override
	public Collection<VariableAccess> getVariables() {
		return Collections.emptyList();
	}

	public String getTo() {
		return to;
	}

	public String getSubject() {
		return subject;
	}

	public String getText() {
		return text;
	}

	public String getAttachment() {
		return attachment;
	}
	
}
