package com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation;

import java.util.Map;

import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.SuperState;
import org.jbpm.graph.node.Decision;
import org.jbpm.graph.node.StartState;
import org.jbpm.graph.node.TaskNode;
import org.jbpm.taskmgmt.def.Task;

import com.tandbergtv.watchpoint.studio.debugger.core.graph.Loop2;
import com.tandbergtv.watchpoint.studio.debugger.core.graph.ProcessState2;
import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.workflow.core.MailNode;
import com.tandbergtv.workflow.core.ManualTaskNode;
import com.tandbergtv.workflow.core.NodeGroup;

/**
 * 		Factory for the NodeSimulator classes
 * 
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class NodeSimulatorFactory {
	
	Map<String, NodeSimulationConfig> simulationConfigMap;
	
	public NodeSimulatorFactory(Map<String, NodeSimulationConfig> simulationConfigMap) {
		this.simulationConfigMap = simulationConfigMap;
	}
	
	/**
	 * 		Gets a simulator for the node specified.
	 * 
	 * @param node
	 * @return The suitable simulator for the node.
	 */
	public NodeSimulator getSimulatorFor(Node node) {
		NodeSimulator simulator = null;
		if (getSuperState(node) instanceof NodeGroup) {
			simulator = new SuperStateNodeSimulator();
			node = getSuperState(node);
		} else if (node instanceof NodeGroup) {
			simulator = new SuperStateNodeSimulator();
		} else if (node instanceof Decision) {
			simulator = new DecisionNodeSimulator();
		} else if (node instanceof Loop2) {
			simulator = new LoopNodeSimulator();
		} else if (node instanceof MailNode) {
			simulator = new MailNodeSimulator();
		} else if (node instanceof ProcessState2) {
			simulator = new SubProcessNodeSimulator();
		} else if (node instanceof ManualTaskNode) {
			simulator = new MessageNodeSimulator();
		} else if (node instanceof TaskNode) {
			Task task = node.getProcessDefinition().getTaskMgmtDefinition().getTask(node.getName());
			if (task == null) {
				// Its an automatic task node
				simulator = new AutomaticTaskNodeSimulator();
			} else {
				simulator = new MessageNodeSimulator(); 
			}
		} else if (node instanceof StartState) {
			simulator = new StartStateNodeSimulator(); 
		}
		
		if (simulator != null) {
			simulator.setNode(node);
			NodeSimulationConfig config = simulationConfigMap.get(node.getName());
			if (config == null) {
				// creates an empty config
				config = new NodeSimulationConfig();
			}
			simulator.setSimulationConfig(config);
		}
		return simulator;
	}
	
	protected Node getSuperState(Node node) {
		Node parent = node;
		
		while (parent.getSuperState() instanceof SuperState) {
			parent = parent.getSuperState();

			if (parent instanceof NodeGroup)
				return parent;
		}
		
		return node;
	}
}
