package com.tandbergtv.watchpoint.studio.debugger.ui;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

/**
 * Sorter for the TableViewerExample that displays items of type 
 * <code>ExampleTask</code>.
 * The sorter supports three sort criteria:
 * <p>
 * <code>DESCRIPTION</code>: Task description (String)
 * </p>
 * <p>
 * <code>OWNER</code>: Task Owner (String)
 * </p>
 * <p>
 * <code>PERCENT_COMPLETE</code>: Task percent completed (int).
 * </p>
 */
public class NodeSimulationTableComparator extends ViewerComparator {

	private int columnIndex;
	private boolean desc;
	private NodeSimulationTableLabelProvider labelProvider = new NodeSimulationTableLabelProvider();
	
	public NodeSimulationTableComparator(String column, boolean desc) {
		this.desc = desc;
		int i = 0;
		for (String c : NodeSimulationTable.COLUMN_NAMES) {
			if (column.equals(c)) {
				break;
			}
			i++;
		}
		this.columnIndex = i;
	}

	@Override
	public int compare(Viewer viewer, Object o1, Object o2) {
		int result = 0;

		String s1 = labelProvider.getColumnText(o1, columnIndex);
		String s2 = labelProvider.getColumnText(o2, columnIndex);
		if (desc == false) {
			result = s1.compareToIgnoreCase(s2);
		} else {
			result = s2.compareToIgnoreCase(s1);
		}
		return result;
	}
	
}
