/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.model;

import com.tandbergtv.watchpoint.studio.debugger.model.JpdlDebugTarget;
import com.tandbergtv.watchpoint.studio.debugger.model.JpdlStackFrame;
import com.tandbergtv.watchpoint.studio.debugger.model.JpdlThread;
import com.tandbergtv.watchpoint.studio.debugger.model.JpdlValue;
import com.tandbergtv.watchpoint.studio.debugger.model.NodeBreakpoint;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import org.eclipse.core.resources.IFile;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.part.FileEditorInput;

public class JpdlModelPresentation
extends LabelProvider
implements IDebugModelPresentation,
IDebugEditorPresentation {
    public void setAttribute(String attribute, Object value) {
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        try {
            StringBuilder text = new StringBuilder();
            if (element instanceof NodeBreakpoint) {
                NodeBreakpoint breakpoint = (NodeBreakpoint)((Object)element);
                text.append(breakpoint.getResourceName());
                text.append(" - ");
                text.append(breakpoint.getNodeName());
            } else if (element instanceof JpdlValue) {
                text.append((CharSequence)this.decorateValue((JpdlValue)((Object)element)));
            } else if (element instanceof JpdlDebugTarget) {
                text.append(((JpdlDebugTarget)((Object)element)).getName());
            } else if (element instanceof JpdlThread) {
                text.append(((JpdlThread)((Object)element)).getName());
            } else if (element instanceof JpdlStackFrame) {
                text.append(((JpdlStackFrame)((Object)element)).getNodeName());
            }
            return text.toString();
        }
        catch (DebugException e) {
            throw new RuntimeException(e);
        }
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
        StringBuilder detail = null;
        try {
            detail = this.decorateValue(value);
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        listener.detailComputed(value, detail.toString());
    }

    private StringBuilder decorateValue(IValue value) throws DebugException {
        StringBuilder detail = new StringBuilder();
        if (value.getReferenceTypeName().contains(String.class.getName())) {
            detail.append("\"").append(value.getValueString()).append("\"");
        } else if (value.getReferenceTypeName().contains(Integer.class.getName())) {
            detail.append(value.getValueString());
        } else {
            detail.append("[");
            detail.append(value.getValueString());
            detail.append("]");
        }
        return detail;
    }

    public IEditorInput getEditorInput(Object element) {
        if (element instanceof IFile) {
            return new FileEditorInput((IFile)element);
        }
        if (element instanceof NodeBreakpoint) {
            return new FileEditorInput((IFile)((NodeBreakpoint)((Object)element)).getMarker().getResource());
        }
        return null;
    }

    public String getEditorId(IEditorInput input, Object element) {
        return "org.jbpm.gd.jpdl.editor";
    }

    public boolean addAnnotations(IEditorPart editorPart, IStackFrame frame) {
        boolean addedAnnotation = false;
        for (NodeDefinition nodeDefinition : Utility.getNodeDefinitions((IEditorPart)editorPart)) {
            if (nodeDefinition.getName().equals(((JpdlStackFrame)frame).getNodeName())) {
                nodeDefinition.setHighlight(true);
                addedAnnotation = true;
            } else {
                nodeDefinition.setHighlight(false);
            }
            Utility.refreshEditPartByNodeName((IEditorPart)editorPart, (String)nodeDefinition.getName());
        }
        return addedAnnotation;
    }

    public void removeAnnotations(IEditorPart editorPart, IThread thread) {
        for (NodeDefinition nodeDefinition : Utility.getNodeDefinitions((IEditorPart)editorPart)) {
            nodeDefinition.setHighlight(false);
            Utility.refreshEditPartByNodeName((IEditorPart)editorPart, (String)nodeDefinition.getName());
        }
    }
}

