/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation;

import com.tandbergtv.watchpoint.studio.debugger.core.graph.Loop2;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationType;
import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.NodeSimulator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;

public class LoopNodeSimulator
extends NodeSimulator {
    protected Transition toFirstNode = null;

    @Override
    public void simulate() {
        if (SimulationType.EXECUTE.equals((Object)this.simulationConfig.getSimulationType())) {
            Loop2 loopNode = (Loop2)this.node;
            this.executionContext.setVariable(loopNode.getIndex(), (Object)loopNode.getInitialValue());
            boolean loop = loopNode.evaluateExpression(this.executionContext);
            if (loop) {
                this.toFirstNode = new Transition("start loop");
                this.toFirstNode.setFrom((Node)loopNode);
                this.toFirstNode.setTo(loopNode.first());
            }
        }
    }

    public List<Transition> getLeavingTransitions() {
        Loop2 loopNode = (Loop2)this.node;
        boolean loop = false;
        if (!SimulationType.SKIP_NODE.equals((Object)this.getSimulationConfig().getSimulationType())) {
            loop = loopNode.evaluateExpression(this.executionContext);
        }
        ArrayList<Transition> transitions = new ArrayList<Transition>();
        if (loop) {
            transitions.add(this.toFirstNode);
        } else {
            transitions.add(loopNode.getDefaultLeavingTransition());
        }
        return transitions;
    }

    @Override
    public boolean fail() {
        return false;
    }

    @Override
    public Collection<VariableAccess> getVariables() {
        return Collections.emptyList();
    }
}

