package com.tandbergtv.watchpoint.studio.debugger.launching;

public class TemplateLauncherConstants {
	
    /**
     * Unique identifier for the Jpdl debug model (value 
     * <code>com.tandbergtv.watchpoint.studio.debugger.jpdl</code>).
     */
    public static final String ID_JPDL_DEBUG_MODEL = "com.tandbergtv.watchpoint.studio.debugger.jpdl";
    
    public static final String LAUNCH_CONFIGURATION_TYPE_IDENTIFIER = "com.tandbergtv.watchpoint.studio.debugger.launchConfigurationType.jpdl";

	public static final String TEMPLATE_LAUNCHER_PERSISTENT_DATA_PREFIX = "com.tandberg.watchpoint.studio";
	
	public static final String TEMPLATE_LAUNCHER_PERSISTENT_DATA_TEMPLATE = TEMPLATE_LAUNCHER_PERSISTENT_DATA_PREFIX + ".template";
	
	public static final String TEMPLATE_LAUNCHER_PERSISTENT_NODES_DATA_PREFIX = TEMPLATE_LAUNCHER_PERSISTENT_DATA_PREFIX + ".nodes";
	
	public static final String TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_TYPE = "simulation.type";
	
	public static final String TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_DATA = "simulation.data";
	
	public static final String TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_DATA_VARIABLES = "variables";
	
	public static final String TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_DATA_FAIL = "fail";
	
	public static final String TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_DATA_FIXED_TRANSITION = "transition";
	
	public static final String CONFIG = "_simulationconfig";
	
	public static String getNodeSimulationDataKey(String nodeName) {
		String prefix = TemplateLauncherConstants.TEMPLATE_LAUNCHER_PERSISTENT_NODES_DATA_PREFIX
			    + "." + nodeName
			    + "." + TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_DATA;
		return prefix;
	}
	
	public static String getNodeSimulationVariablesKey(String nodeName, String variableName) {
		String prefix = getNodeSimulationDataKey(nodeName) 
		          + "." + TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_DATA_VARIABLES
		          + "." + variableName;
		return prefix;
	}
	
	public static String getNodeSimulationTypeKey(String nodeName) {
		String prefix = TemplateLauncherConstants.TEMPLATE_LAUNCHER_PERSISTENT_NODES_DATA_PREFIX
			    + "." + nodeName
			    + "." + TEMPLATE_LAUNCHER_PERSISTENT_NODES_SIMULATION_TYPE;
		return prefix;
	}
	
}
