package com.tandbergtv.watchpoint.studio.debugger.ui;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;
import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Transition;

import com.tandbergtv.watchpoint.studio.debugger.model.DecisionSimulationData;
import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationType;

public class DecisionNodeSimulationComposite extends AbstractNodeSimulationComposite {
	
	protected Label lblFixedTransition;
	protected Combo cmbFixedTransition;
	
	public DecisionNodeSimulationComposite(Composite parent, NodeSimulationConfig node) {
		super(parent, node);
	}

	@Override
	protected void createAdditionalControls(Composite parent) {
		createFixedTransitionWidget(parent);
	}
	
	protected void createFixedTransitionWidget(Composite composite) {
		lblFixedTransition = new Label(composite, SWT.NONE);
		lblFixedTransition.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblFixedTransition.setText("Fixed Transition :");
		
		cmbFixedTransition = new Combo(composite, SWT.NONE);
		cmbFixedTransition.addSelectionListener(this);
	}
	
	@Override
	public void load(NodeSimulationConfig nodeSimulationConfig) {
		super.load(nodeSimulationConfig);
		
		NodeElement nodeElement = nodeSimulationConfig.getNodeElement();
		cmbFixedTransition.add("");
		for (Transition transition : nodeElement.getTransitions()) {
			cmbFixedTransition.add(transition.getName());
		}
		String fixedTransition = getSimulationData().getFixedTransitionName();
		if (fixedTransition != null) {
			cmbFixedTransition.setText(fixedTransition);
		}
		updateWidgets();
	}
	
	public DecisionSimulationData getSimulationData() {
		DecisionSimulationData result = null;
		if (!(nodeSimulationConfig.getSimulationData() instanceof DecisionSimulationData)) {
			result = new DecisionSimulationData(nodeSimulationConfig.getSimulationData());
		} else {
			result = (DecisionSimulationData) nodeSimulationConfig.getSimulationData();
		}
		nodeSimulationConfig.setSimulationData(result);
		return result;
	}


	@Override
	protected SimulationType[] getSimulationTypes() {
		return new SimulationType[] {SimulationType.EXECUTE, SimulationType.FIXED_TRANSITION};
	}

	protected void updateWidgets() {
		boolean isFixedTransition = SimulationType.FIXED_TRANSITION.equals(nodeSimulationConfig.getSimulationType());
		cmbFixedTransition.setEnabled(isFixedTransition);
		lblFixedTransition.setEnabled(isFixedTransition);
	}
	
	/**
	 * 		Notifies when a widget is selected. Subclasses may override.
	 */
	@Override
	public void widgetSelected(SelectionEvent e) {
		Widget widget = (Widget) e.getSource();
		if (SimulationType.FIXED_TRANSITION.equals(widget.getData())) {
			Button btn = (Button) widget;
			if (btn.getSelection()) {
				nodeSimulationConfig.setSimulationType(SimulationType.FIXED_TRANSITION);
			}
			updateWidgets();
			fireSimulationModifiedEvent(nodeSimulationConfig);
		} else if (SimulationType.EXECUTE.equals(widget.getData())) { 
			Button btn = (Button) widget;
			if (btn.getSelection()) {
				nodeSimulationConfig.setSimulationType(SimulationType.EXECUTE);
			}
			updateWidgets();
			fireSimulationModifiedEvent(nodeSimulationConfig);
		} else if (widget == cmbFixedTransition) {
			getSimulationData().setFixedTransitionName(cmbFixedTransition.getText());
			fireSimulationModifiedEvent(nodeSimulationConfig);
		}
	}

}
