package com.tandbergtv.watchpoint.studio.debugger.ui;

import java.util.Collection;

import org.eclipse.core.resources.IProject;
import org.eclipse.swt.widgets.Composite;
import org.jbpm.gd.jpdl.model.Variable;

import com.tandbergtv.watchpoint.studio.ui.editor.expression.ExpressionEditor;
import com.tandbergtv.watchpoint.studio.ui.model.IExpression;
import com.tandbergtv.watchpoint.studio.ui.model.IValidatableElement;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.DataType;

public class VariableExpressionValuesTable extends VariableValuesTable {

    private ExpressionEditor expressionEditor;

	public VariableExpressionValuesTable(Composite parent) {
		super(parent);
		tableViewer.getCellEditors()[VALUE_COLUMN_INDEX] = new VariableExpressionCellEditor(this.table);
		tableViewer.setLabelProvider(new VariableExpressionValuesTableLabelProvider());
        expressionEditor = new ExpressionEditor(tableViewer, VALUE_COLUMN_INDEX);
	}

	public void initializeExpressionEditor() {
        expressionEditor.setExpression(new CustomExpression());
        expressionEditor.initialize();
	}

	public void setProject(IProject project) {
		expressionEditor.setProject(project);
	}

	public void setContextVariables(Collection<Variable> contextVariables) {
		expressionEditor.setContextVariables(contextVariables);
	}

    public class CustomExpression implements IExpression {

        private WPVariable variable;

        @Override
        public void setModel(IValidatableElement variable) {
            this.variable = (WPVariable) variable;
        }

        @Override
        public IValidatableElement getModel() {
            return variable;
        }

        @Override
        public DataType getReturnType() {
            return DataType.valueOf(variable.getType());
        }

        @Override
        public String getText() {
            return variable.getValue();
        }

        @Override
        public boolean isValidatable() {
            return variable.isWritable();
        }
    }
}