/*
 * Created on June 5, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dto;

import java.util.HashSet;
import java.util.Set;

/**
 * The Workflow Template DTO.
 * 
 * @author Imran Naqvi
 */
public class WorkflowTemplateDTO implements IWatchPointDTO, IVersionable, IPersistable
{
	
	public static final String DEFAULT_TEMPLATE_PACKAGE_EXTENSION = ".par";
	
	public static final String TEMPLATE_DEFINITION_FILE_EXTENSION_NAME = "jpdl"; 
	
	public static final String TEMPLATE_DEFINITION_FILE_NAME = "processdefinition.jpdl"; 
	public static final String TEMPLATE_RUNTIME_FILE_NAME = "processdefinition.xml";
	public static final String TEMPLATE_RUNTIME_FILE_EXTENSION = ".xml";
	public static final String GPD_FILE_NAME = "processdefinition.gpd";
	public static final String GPD_FILE_EXTENSION = ".gpd";
	public static final String TEMPLATE_IMAGE_FILE_NAME = "processimage.jpg";
	
	private static final long serialVersionUID = 8573005139082888461L;

	private long id = DEFAULT_ID;
	
	private String path;
	
	private String projectName;

	private String name;

	private String xml;

	private Set<ProtectionKey> protectionKeys;
	
	private Set<TemplateMessageDTO> messages;
	
	private Set<TemplateSubProcessDTO> subprocesses;
	
	private Set<TemplateManualTaskNodeDTO> manualTaskNodes;

	private int version;

	private boolean dirty;

	private boolean hasErrors;
	
	private boolean hasWarnings;

	/**
	 * default constructor
	 */
	public WorkflowTemplateDTO()
	{
		super();
		this.protectionKeys = new HashSet<ProtectionKey>();
		this.messages = new HashSet<TemplateMessageDTO>();
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.dto.IPersistable#getKey()
	 */
	public Long getKey()
	{
		return this.id;
	}

	/**
	 * @return the id
	 */
	public long getId()
	{
		return this.id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(long id)
	{
		this.id = id;
	}

	/**
	 * 
	 * @return the name of this template
	 */
	public String getName()
	{
		return name;
	}

	/**
	 * 
	 * @param name
	 *            the name to set for this template
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * 
	 * @return the xml representing the template
	 */
	@Deprecated
	public String getXml()
	{
		return xml;
	}

	/**
	 * 
	 * @param xml
	 *            The xml to set
	 */
	@Deprecated
	public void setXml(String xml)
	{
		this.xml = xml;
	}

	/**
	 * @return the Protection Keys for the Template
	 */
	public Set<ProtectionKey> getProtectionKeys()
	{
		return this.protectionKeys;
	}

	/**
	 * @param protectionKeys
	 *            the Protection Keys for the Template
	 */
	public void setProtectionKeys(Set<ProtectionKey> protectionKeys)
	{
		this.protectionKeys = protectionKeys;
	}
	
	/**
	 * Adds the specified protection key
	 * 
	 * @param key
	 */
	public void addProtectionKey(ProtectionKey key)
	{
		this.protectionKeys.add(key);
	}

	/**
	 * Gets the version of the template
	 * 
	 * @see com.tandbergtv.watchpoint.studio.dto.IVersionable#getVersion()
	 */
	public int getVersion()
	{
		return version;
	}

	/**
	 * The version to set for the template
	 * 
	 * @see com.tandbergtv.watchpoint.studio.dto.IVersionable#setVersion(int)
	 */
	public void setVersion(int version)
	{
		this.version = version;
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.dto.IVersionable#isDirty()
	 */
	@Deprecated
	public boolean isDirty()
	{
		return this.dirty;
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.dto.IVersionable#setDirty(boolean)
	 */
	@Deprecated
	public void setDirty(boolean dirty)
	{
		this.dirty = dirty;
	}
	
	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}

	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode()
	{
		if (this.id == DEFAULT_ID)
			return super.hashCode();

		return new Long(this.id).hashCode() * 3 - 43;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj)
	{
		if (!(obj instanceof WorkflowTemplateDTO))
			return false;

		WorkflowTemplateDTO key = (WorkflowTemplateDTO) obj;

		/* Check for the Default Id */
		if (this.id == DEFAULT_ID && key.id == DEFAULT_ID)
			return super.equals(key);

		return (this.id == key.id);
	}

	/**
	 * Creates a clone of the Node Definition.
	 * 
	 * @see java.lang.Object#clone()
	 */
	@Override
	public WorkflowTemplateDTO clone()
	{
		WorkflowTemplateDTO clone = null;

		try
		{
			clone = (WorkflowTemplateDTO) super.clone();

			if (this.protectionKeys != null)
			{
				clone.protectionKeys = new HashSet<ProtectionKey>(this.protectionKeys);
			}
		}
		catch (CloneNotSupportedException ex)
		{ // Should never happen
		}

		return clone;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString()
	{
		return name + " - v" + version;
	}

	public Set<TemplateMessageDTO> getMessages() {
		return messages;
	}

	public void setMessages(Set<TemplateMessageDTO> messages) {
		this.messages = messages;
	}

	public Set<TemplateSubProcessDTO> getSubprocesses() {
		return subprocesses;
	}

	public void setSubprocesses(Set<TemplateSubProcessDTO> subprocesses) {
		this.subprocesses = subprocesses;
	}
	
	public Set<TemplateManualTaskNodeDTO> getManualTaskNodes() {
		return manualTaskNodes;
	}

	public void setManualTaskNodes(Set<TemplateManualTaskNodeDTO> manualTaskNodes) {
		this.manualTaskNodes = manualTaskNodes;
	}

	public boolean isHasErrors() {
		return hasErrors;
	}

	public void setHasErrors(boolean hasErrors) {
		this.hasErrors = hasErrors;
	}

	public boolean isHasWarnings() {
		return hasWarnings;
	}

	public void setHasWarnings(boolean hasWarnings) {
		this.hasWarnings = hasWarnings;
	}
	
}
