/*
 * Created on Aug 2, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.external.wpexport;

/**
 * The list of Input Attribute Keys for the Exporter.
 * 
 * @author Vijay Silva
 */
public final class ExporterInputAttributes
{
	/* Cannot instantiate */
	private ExporterInputAttributes()
	{
	}

	/**
	 * Input Attribute that maintains the file path to use when writing out the object to be
	 * exported to a file. The attribute value is a String.
	 */
	public static final String EXPORT_FILE_PATH = "exportFilePath";
	
	/**
	 * Input Attribute that maintains the folder path to use when writing out the object to be
	 * exported to a folder. The attribute value is a String.
	 */
	public static final String EXPORT_FOLDER_PATH = "exportFolderPath";

	/**
	 * Input Attribute that maintains a list of String paths to each of the jar / library files that
	 * need to be included when exporting a plug-in. The attribute value is a List<String>.
	 */
	public static final String PLUGIN_JAR_FILE_PATHS = "jarFilePathList";

	/**
	 * Input Attribute that maintains a list of String paths to each of the folders / files for the
	 * class files that need to be included when exporting a plug-in. The value for this attribute
	 * is of type: List<String>.
	 */
	public static final String PLUGIN_CLASSES_FILE_PATHS = "classFilePathList";

	/**
	 * Input Attribute that maintains a list of String paths to each of the folders / files for the
	 * class files that need to be included when exporting a plug-in. The value for this attribute
	 * is of type: List<String>.
	 */
	public static final String PLUGIN_RESOURCE_FILE_PATHS = "resourceFilePathList";
	
	/**
	 * Input Attribute that defines what filesystem will be used during export: Machine's local
	 * filesystem, or eclipse's workspace.
	 * If not specified, TargetFilesystem.LOCAL_FILESYSTEM will be considered as default. 
	 * The value for this attribute is of type: TargetFilesystem.
	 */
	public static final String TARGET_FILESYSTEM = "targetFilesystem";

	public enum TargetFilesystem {
		/** Represents the local filesystem.*/
		LOCAL_FILESYSTEM, 
		/** Represents the Eclipse Workspace. */
		ECLIPSE_WORKSPACE;
	}
}

