/*
 * Created on Jul 31, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.external.wpexport.impl;

import com.tandbergtv.watchpoint.studio.application.StudioRuntimeException;
import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.external.wpexport.IWatchPointDTOExporter;
import com.tandbergtv.watchpoint.studio.external.wpexport.WatchPointDTOExporterFactory;

/**
 * Default implementation of the Exporter Factory
 * 
 * @author Vijay Silva
 */
public class DefaultExporterFactory extends WatchPointDTOExporterFactory
{
	/**
	 * @see com.tandbergtv.watchpoint.studio.external.wpexport.WatchPointDTOExporterFactory#getExporter(java.lang.Class)
	 */
	@SuppressWarnings("unchecked")
	@Override
	public <T extends IWatchPointDTO> IWatchPointDTOExporter<T> getExporter(Class<T> type)
	{
		IWatchPointDTOExporter exporter = null;

		if (WorkflowTemplateDTO.class.equals(type))
		{
			exporter = new WorkflowTemplateFileExporter();
		}
		else if (ResourceGroup.class.equals(type))
		{
			exporter = new ResourceGroupExporter();
		}
		else
		{
			String className = type.getName();
			String msg = "No WatchPointDTOExporter available for class: " + className;
			throw new StudioRuntimeException(msg);
		}

		return exporter;
	}
}
