/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import java.util.List;

import org.dom4j.Element;
import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.notation.NodeContainer;
import org.jbpm.gd.jpdl.editor.JpdlContentProvider;

import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;

/**
 * Content provider for WatchPoint studio templates.
 * 
 * @author Imran Naqvi
 */
public class WPContentProvider extends JpdlContentProvider {

	@Override
	protected void addNodes(NodeContainer nodeContainer, SemanticElement[] semanticElements,
			Element notationInfo) {
		addNotationNodes(nodeContainer, notationInfo);
	}

	private void addNotationNodes(NodeContainer nodeContainer, Element notationInfo) {
		List<?> nodes = notationInfo.elements();
		
		for (int i = 0; i < nodes.size(); i++) {
			SemanticElement nodeSemanticElement = getNodeSemanticElement(nodeContainer, (Element)nodes.get(i), i);
			
			/* Deals with cases where the GPD has a node that is missing in the JPDL */
			if (nodeSemanticElement != null) {
				addNode(nodeContainer, nodeSemanticElement, (Element)nodes.get(i));	
			}
		}
	}
	
	protected String getSemanticInfoFileName(String notationInfoFileName) {
		return WorkflowTemplateDTO.TEMPLATE_DEFINITION_FILE_NAME;
	}
	
	protected String getNotationInfoFileName(String semanticInfoFileName) {
		return WorkflowTemplateDTO.GPD_FILE_NAME;
	}
}
