package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.fields;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.util.UIValidator;

public class RTGeneralPageDescField implements IResourceTypeGeneralPageInputField{
	
	private Text descText;
	
	public RTGeneralPageDescField() {
		super();
	}

	@Override
	public void createControls(Composite parent, GridData labelData, GridData controlData) {
				
//		formData.height = 200;
		
		//description label
		Label descLabel = new Label(parent, SWT.NONE);
		descLabel.setText("Description : ");
		
		//description text
		descText = new Text(parent, SWT.BORDER | SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL);
		descText.setTextLimit(256);
		
		//description label
		descLabel.setLayoutData(labelData);

		//description text
		controlData.widthHint = 300;
		controlData.heightHint = 100;
		descText.setLayoutData(controlData);
	}

	@Override
	public void setObjectValues(ResourceType rt) {
			rt.setDescription(convertEmptyToNull(descText.getText()));
	}

	@Override
	public void clearControls() {
		
	}

	@Override
	public void initValues() {
	}

	@Override
	public String validate() {
		return UIValidator.validateValue("Description", descText.getText(), UIValidator.Validation.TRIMMED);
	}

	@Override
	public void setFormPartDirtyModifyListener(ModifyListener validationListener) {
		descText.addModifyListener(validationListener);
	}
	
	private String convertEmptyToNull(String str) {
		return ((str.length() == 0) ? null : str);
	}
	
	/* Creates a blank string for null values, and trims if required */
	protected String formatValue(String value, boolean trim)
	{
		String newValue = null;

		if (value == null)
			newValue = "";
		else if (trim)
			newValue = value.trim();
		else
			newValue = value;

		return newValue;
	}

	@Override
	public void setCurrentValue(ResourceType resourceType) {
		this.descText.setText(this.formatValue(resourceType.getDescription(), false));
	}

	@Override
	public void setWidgetPermission(boolean isEditable) {
		this.descText.setEditable(isEditable);
	}

}
