package com.tandbergtv.watchpoint.studio.ui.model;

import java.util.List;

import org.jbpm.gd.common.model.SemanticElement;

/**
 * An interface for any component that contain variables.
 *  
 * @author Raj Prakash
 *
 */
public interface IWPVariableContainer extends SemanticElement {

	/**
	 * Gets the variables this IMessageNodeContainer sends or receives.
	 * 
	 * @return The list of Variables
	 */
	List<WPVariable> getVariables();

	/**
	 * Adds a variable to this Node Definition's variables.
	 * 
	 * @param variable
	 *            variable to add
	 */
	void addVariable(WPVariable variable);

	/**
	 * Removes the variable with the given name.
	 * 
	 * @param name
	 *            name of the variable to remove
	 * @return the variable which was remove; null if no variable with the given name exists
	 */
	WPVariable removeVariable(String name);
	
	/**
	 * Returns true if there is a variable with the given mapped name
	 * 
	 * @param name
	 * @return
	 */
	boolean hasVariable(String name);
}
