package com.tandbergtv.watchpoint.studio.ui.preferences;

import static com.tandbergtv.watchpoint.studio.ui.preferences.PreferenceConstants.AUTO_EXPORT_RESOURCE_GROUPS;
import static com.tandbergtv.watchpoint.studio.ui.preferences.PreferenceConstants.EXPORT_DIR;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import com.tandbergtv.watchpoint.studio.ui.UI;
import com.tandbergtv.watchpoint.studio.ui.WatchPointStudioPlugin;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */
public class PreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

    private DirectoryFieldEditor dir;
    private BooleanFieldEditor exportImage;
    private BooleanFieldEditor autoExportResourceGroups;

    public PreferencePage() {
        super(GRID);
        setPreferenceStore(WatchPointStudioPlugin.getDefault().getPreferenceStore());
        setDescription(UI.PreferencePage_Title);
    }

    /**
     * Creates the field editors. Field editors are abstractions of the common GUI blocks needed to manipulate various
     * types of preferences. Each field editor knows how to save and restore itself.
     */
    @Override
    public void createFieldEditors() {
        dir = new DirectoryFieldEditor(EXPORT_DIR, UI.PreferencePage_Location, getFieldEditorParent());
        dir.setEmptyStringAllowed(false);

        exportImage = new BooleanFieldEditor(PreferenceConstants.EXPORT_IMAGE, UI.PreferencePage_ExportImage,
                getFieldEditorParent());

        autoExportResourceGroups = new BooleanFieldEditor(AUTO_EXPORT_RESOURCE_GROUPS,
                UI.PreferencePage_AutoExportResourceGroup, getFieldEditorParent());

        addField(dir);
        addField(exportImage);
        addField(autoExportResourceGroups);
    }

    /* (non-Javadoc)
     * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
     */
    @Override
    public void init(IWorkbench workbench) {
    }

    /* (non-Javadoc)
     * @see org.eclipse.jface.preference.FieldEditorPreferencePage#checkState()
     */
    @Override
    protected void checkState() {
        super.checkState();

        if (!isValid()) {
            return;
        }

        setErrorMessage(null);
        setValid(true);
    }
}
