package com.tandbergtv.watchpoint.studio.ui.preferences;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jdt.internal.ui.IJavaHelpContextIds;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

import com.tandbergtv.watchpoint.studio.ui.WatchPointStudioPlugin;

/**
 * Page used to configure both workspace and project specific compiler settings
 */
public class ValidationLevelPreferencePage extends com.tandbergtv.watchpoint.studio.eclipse.custom.ValidationLevelPreferencePage {

	public ValidationLevelPreferencePage() {
		
	    setPreferenceStore(WatchPointStudioPlugin.getDefault().getPreferenceStore());
		//setDescription(PreferencesMessages.getString("ProblemSeveritiesPreferencePage.description")); //$NON-NLS-1$

		// only used when page is shown programatically
		setTitle(PreferencesMessages.ValidationLevelPreferencePage_title);

		Map<String, Object> data = new HashMap<String, Object>();
		data.put(DATA_NO_LINK, Boolean.TRUE);
		applyData(data);
	}
	
	/*
	 * @see org.eclipse.jface.dialogs.IDialogPage#createControl(org.eclipse.swt.widgets.Composite)
	 */
	@Override
	public void createControl(Composite parent) {
	    IWorkbenchPreferenceContainer container= (IWorkbenchPreferenceContainer) getContainer();
		fConfigurationBlock= new ValidationLevelConfigurationBlock(getNewStatusChangedListener(), getProject(), container);
		super.createControl(parent);
		if (isProjectPreferencePage()) {
			PlatformUI.getWorkbench().getHelpSystem().setHelp(getControl(), IJavaHelpContextIds.PROBLEM_SEVERITIES_PROPERTY_PAGE);
		} else {
			PlatformUI.getWorkbench().getHelpSystem().setHelp(getControl(), IJavaHelpContextIds.PROBLEM_SEVERITIES_PREFERENCE_PAGE);
		}
	}
}
