package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableColumn;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;

public class ProcessStateLabelProvider extends WPLabelProvider {

    public ProcessStateLabelProvider(TableColumn readColumn, TableColumn writeColumn, TableColumn requiredColumn) {
        this.columns = new TableColumn[] { readColumn, writeColumn, requiredColumn };
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        WPVariable model = (WPVariable) element;
        switch (columnIndex) {
        case 0:
            if (model.getError() != null && ((Object[]) model.getError())[0].equals(Boolean.TRUE)) {
                return getImage(FieldDecorationRegistry.DEC_ERROR);
            } else if (!model.isWritable()) {
                return getImage(FieldDecorationRegistry.DEC_CONTENT_PROPOSAL);
            }
            return null;
        case 2:
            return getCheckImage(model.isReadable());
        case 3:
            return getCheckImage(model.isWritable());
        case 4:
            return getCheckImage(model.isRequired());
        }
        return null;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
        case 0:
            return ((WPVariable) element).getName();
        case 1:
            return ((WPVariable) element).getMappedName();
        }
        return null;
    }

}