/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import java.io.IOException;
import java.util.HashSet;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Set;

import org.apache.log4j.Logger;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.bindings.keys.ParseException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.SimpleContentProposalProvider;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.jbpm.gd.jpdl.model.NodeElementContainer;
import org.jbpm.gd.jpdl.properties.WPDecisionConfigurationCompositeCustom;

import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.ui.util.ValidationMessages;
import com.tandbergtv.watchpoint.studio.validation.IValidationService;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationServiceFactory;

public class WPDecisionConfigurationComposite extends WPDecisionConfigurationCompositeCustom{
	private static final Logger logger = Logger.getLogger(WPDecisionConfigurationComposite.class);

	public static WPDecisionConfigurationComposite create(AbstractPropertySection parentSection, 
			TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
		WPDecisionConfigurationComposite result = new WPDecisionConfigurationComposite();
		result.setParentPropertySection(parentSection);
		result.setWidgetFactory(widgetFactory);
		result.setParent(parent);
		result.create();
		return result;
	}

	@Override
	public void focusLost(FocusEvent e) {
		if (e.widget == super.getExpressionText()) {
			updateExpressionText();
			if(Utility.getNodeElementContainer(super.getParentPropertySection().getPart())!=null)
				validate();
		}

	}
	
	/*
	 * Creates an adapter for Content Assist
	 */
	@Override
	protected ContentProposalAdapter createAdapter(Text text, String[] proposals, boolean propogate) {
		char[] autoActivationCharacters = new char[] {};
		KeyStroke keyStroke = null;
		try {
			keyStroke = KeyStroke.getInstance("Ctrl+Space");
		} catch (ParseException e1) {
			logger.error("Error occured while Creating instance of KeyStroke", e1);
			throw new UIException("Error occured while Creating instance of KeyStroke");
		}
		SimpleContentProposalProvider scp = new SimpleContentProposalProvider(proposals);
		ContentProposalAdapter adapter = new ContentProposalAdapter(text, new TextContentAdapter(),
				scp, keyStroke, autoActivationCharacters);
		adapter.setProposalAcceptanceStyle(ContentProposalAdapter.PROPOSAL_INSERT);
		adapter.setFilterStyle(ContentProposalAdapter.FILTER_CUMULATIVE);
		adapter.setPropagateKeys(propogate);
		adapter.setEnabled(false);
		return adapter;
	}
	
	/*
	 * Gets the proposals
	 */
	@Override
	protected String[] getTextProposals() {
		List<WPVariable> variables = Utility.getVariables(Utility.getNodeElementContainer(super.getParentPropertySection().getPart()));
		Set<String> variableNames = new HashSet<String>();
		for (WPVariable variable : variables) {
			String name = variable.getName();
			if (name != null && name.trim().length() > 0)
				variableNames.add(variable.getName());
		}
		String proposals[] = variableNames.toArray(new String[variableNames.size()]);

		return proposals;
	}
	/*
	 * Validates the Decision Expression
	 */
	@Override
	protected void validate() {
		ValidationServiceFactory serviceFactory = ValidationServiceFactory.createFactory();
		IValidationService validationService = serviceFactory.createValidationService();
		NodeElementContainer container = Utility.getNodeElementContainer(super.getParentPropertySection().getPart());
		List<ValidationMessage> messages = null;
		if (container instanceof WorkflowTemplate)
			messages = validationService.validateDecisionExpression(super.getDecision(),
					(WorkflowTemplate) container);
		else if (container instanceof NodeDefinition)
			messages = validationService.validateDecisionExpression(super.getDecision(),
					(NodeDefinition) container);
			

		if (messages != null && messages.size() > 0) {

			try {
				String msg = ValidationMessages.getInstance().getMessage(messages.get(0));
				MessageDialog.openError(Display.getCurrent().getActiveShell(),
						"Error in Decision Expression", msg);

			} catch (InvalidPropertiesFormatException e1) {
				logger.error("Error occured while opening the Message Dialog", e1);
				throw new UIException("Error occured while opening the Message Dialog");
			} catch (IOException e1) {
				logger.error("Error occured while opening the Message Dialog", e1);
				throw new UIException("Error occured while opening the Message Dialog");
			}

		}
	}
}
