package com.tandbergtv.watchpoint.studio.ui.properties.filter;

import org.jbpm.gd.common.model.SemanticElement;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;


public class ExceptionHandlerFilter extends WPPropertyFilter {

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.properties.filter.WPPropertyFilter#selectModelElement(org.jbpm.gd.common.model.SemanticElement)
	 */
	@Override
	protected boolean selectModelElement(SemanticElement modelElement) {
		if (this.container == null)
			return false;
		
		if (modelElement instanceof NodeDefinition) {

			NodeDefinition node = NodeDefinition.class.cast(modelElement);

			if (node.getNode() == null)
				return false;
			
			return true;
		}
		
		if (modelElement instanceof WorkflowTemplate)
				return true;

		return false;
	}
}
