/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.properties.filter;

import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.Transition;

/**
 * A filter for transitions whose source is a decision node.
 * 
 * @author Imran Naqvi
 */
public class TransitionConditionFilter extends WPPropertyFilter {

	/**
	 * @see com.tandbergtv.watchpoint.studio.ui.properties.filter.WPPropertyFilter#selectModelElement(org.jbpm.gd.common.model.SemanticElement)
	 */
	@Override
	protected boolean selectModelElement(SemanticElement modelElement) {
		if(!(modelElement instanceof Transition))
			return false;
		Transition transition = (Transition) modelElement;
		
		return (transition.getSource() instanceof Decision);
	}

}
