/**
 * UpdateElement.java
 * Created May 6, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync.impl;

import org.jbpm.gd.common.model.SemanticElement;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.ui.sync.DiffKind;
import com.tandbergtv.watchpoint.studio.ui.sync.IUpdateElement;

/**
 * Represents an update to a model object. The model object being changed is the "local" element.
 * 
 * @author Sahil Verma
 */
public class UpdateElement extends Diff implements IUpdateElement {

	protected IWatchPointDTO local;
	
	protected SemanticElement localElement;
	
	/**
	 * Creates an {@link UpdateElement}
	 * @param model
	 * @param element
	 * @param kind
	 */
	public UpdateElement(IWatchPointDTO local, IWatchPointDTO model, SemanticElement element, DiffKind kind) {
		super(model, element, kind);
		this.local = local;
	}
	
	/**
	 * {@inheritDoc}
	 */
	public IWatchPointDTO getLocalModel() {
		return local;
	}
}
