/**
 * AbstractNodeCommand.java
 * Created Apr 24, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync.resource;

import javax.xml.transform.TransformerException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.sync.IDiff;
import com.tandbergtv.watchpoint.studio.ui.sync.SynchronizationException;
import com.tandbergtv.watchpoint.studio.ui.sync.command.AbstractDiffCommand;
import com.tandbergtv.watchpoint.studio.ui.sync.util.ISynchronizationContext;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;
import com.tandbergtv.watchpoint.studio.util.FileUtil;

/**
 * Abstract parent of all commands that deal with nodes
 * 
 * @author Sahil Verma
 */
public abstract class AbstractNodeCommand extends AbstractDiffCommand {

	protected NodeDefinitionDTO model;
	
	protected NodeDefinition element;
	
	/**
	 * Creates an {@link AbstractNodeCommand}
	 * 
	 * @param name
	 * @param diff
	 * @param context
	 */
	protected AbstractNodeCommand(String name, IDiff diff, ISynchronizationContext context) {
		super(name, diff, context);
		model = (NodeDefinitionDTO) diff.getModel();
		element = (NodeDefinition) diff.getElement();
	}

	/**
	 * {@inheritDoc}
	 */
	public void execute() {
		updateRelationships();
		updateNodeDefinitionXml();
	}
	
	protected abstract void updateRelationships();
	
	protected void updateNodeDefinitionXml() {
		try {
			Document document = Utility.getDocumentFromString(model.getXml());
			Element e = document.getDocumentElement();

			e.setAttribute("resourceType", String.valueOf(model.getResourceType().getId()));
			
			String xml = FileUtil.convertDocument(document);
			model.setXml(xml);
		} catch (TransformerException e) {
			throw new SynchronizationException("Failed to convert node XML", e);
		}
	}
}
