package com.tandbergtv.watchpoint.studio.ui.view.resourcetype;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.ui.statushandlers.StatusManager;

import com.tandbergtv.watchpoint.studio.builder.WatchpointResourceTypeNature;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.util.NameValuePair;

public class NodeContentTester extends PropertyTester {

	public NodeContentTester() {
	}

	@Override
	public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
		if(property.equals("isSuperState")){
			if (receiver instanceof NodeDefinitionDTO) {
				NodeDefinitionDTO nodeDefinition = (NodeDefinitionDTO) receiver;
				if (nodeDefinition.getType() == NodeDefinitionType.SuperState) {
					return true;
				}
			}
		}
		
		if(property.equals("isResourceTypeProject")){
			if(receiver instanceof IProject){
				IProject project = (IProject) receiver;
				if(project.exists() && project.isOpen()){
					try {
						if ( project.hasNature(WatchpointResourceTypeNature.NATURE_ID) ){
							return true;
						}
					} catch (CoreException e) {
						String errorMessage = "Error verifying the project " + project.getName() + " nature.";
						Status status = new Status(IStatus.ERROR, "WatchPoint Studio",IStatus.ERROR, errorMessage, e);
						StatusManager.getManager().handle(status, StatusManager.SHOW);
					}
				}
			}
		}
		
		if(property.equals("isMessageNode")){
			if (receiver instanceof NodeDefinitionDTO) {
				NodeDefinitionDTO nodeDefinition = (NodeDefinitionDTO) receiver;
				if (nodeDefinition.getType() == NodeDefinitionType.MessageNode) {
					return true;
				}
			}
			// Checks if a (WPVariable||NameValuePair) is a Message Node child
			if (receiver instanceof WPVariable || receiver instanceof NameValuePair) {
				/* Ideally, WPVariable should be a DTO with bi-directional association
				 * to NodeDefinitionDTO but for now, we navigate through the ProjectExplorer tree
				 * to get the NodeDefinition reference. */
				IWorkbenchWindow dwindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
				IWorkbenchPage page = dwindow.getActivePage();
				if (page != null) {
					IViewPart part = page.findView(ProjectExplorer.VIEW_ID);
					if (part != null) {
						TreeViewer treeViewer = ((TreeViewer) part.getAdapter(CommonViewer.class));
						ISelection selection = treeViewer.getSelection();
						TreePath[] paths = ((TreeSelection) selection).getPaths();
						TreePath path = (paths != null) ? paths[0] : null;
						if(path != null){
							NodeDefinitionDTO nodeDefinition = (NodeDefinitionDTO) path.getSegment(2);
							if (nodeDefinition.getType() == NodeDefinitionType.MessageNode) {
								return true;
							}
						}
					}
				}
			}
		}
		
		return false;
	}
}
