package com.tandbergtv.watchpoint.studio.ui.wizard;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * The wizard page for creating new WatchPoint Templates.
 * 
 * @author Imran Naqvi
 *
 */
public class NewWatchPointTemplateWizardPage extends WizardPage {

	private Text processText;
	
	public NewWatchPointTemplateWizardPage(String title, String description) {
		super("Template");
		setTitle(title);
		setDescription(description);
	}

	public void createControl(Composite parent) {
		initializeDialogUnits(parent);
		Composite composite = createClientArea(parent);		
		createLabel(composite);	
		createProcessField(composite);
		setControl(composite);
		Dialog.applyDialogFont(composite);
	}

	public String getProcessName() {
		return processText.getText();
	}
	
	private Composite createClientArea(Composite parent) {
		Composite composite= new Composite(parent, SWT.NONE);
		GridLayout layout= new GridLayout();
		layout.marginWidth= 0;
		layout.marginHeight= 0;
		layout.numColumns= 3;
		composite.setLayout(layout);
		return composite;
	}	

	private void createLabel(Composite composite) {
		Label label= new Label(composite, SWT.WRAP);
		label.setText("Choose a template name.");
		GridData gd= new GridData();
		gd.widthHint= convertWidthInCharsToPixels(80);
		gd.horizontalSpan= 3;
		label.setLayoutData(gd);
	}
	
	private void createProcessField(Composite parent) {
		Label label = new Label(parent, SWT.NONE);
		label.setText("Template name : ");
		processText = new Text(parent, SWT.BORDER);
		processText.setTextLimit(50);
		processText.addKeyListener(new KeyListener() {
			public void keyPressed(KeyEvent e) {
			}

			public void keyReleased(KeyEvent e) {
				checkNodeDefinitionName();
				getContainer().updateButtons();
			}

			private void checkNodeDefinitionName() {
				String errorMessage = null;
				if (processText.getText().equals(""))
					errorMessage = "Template name can not be empty.";
				else if (processText.getText().startsWith(" ") || processText.getText().endsWith(" "))
					errorMessage = "Template name is not valid. The Template name must not start or end with a blank.";
				if (errorMessage != null)
					setErrorMessage(errorMessage);
				else
					setErrorMessage(null);
			}
		});
		
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		processText.setLayoutData(gd);		
	}

}
