package com.tandbergtv.watchpoint.studio.ui.xml;

import org.jbpm.gd.jpdl.xml.TextDomAdapter;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/**
 * 		Adapter for 'Text' element that doens't add padding characters.
 * 
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class TextNoPaddingDomAdapter extends TextDomAdapter {


	@Override
	protected void replaceTextChild(String content) {
		Text text = getNode().getOwnerDocument().createTextNode(content);
		getNode().appendChild(text);
	}
}
