package com.tandbergtv.watchpoint.studio.util;

import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;
import com.tandbergtv.watchpoint.studio.validation.model.DueDateExpression;

/**
 * @author Raj Prakash
 *
 * Validates Due Date Expression. 
 */
public class DueDateExprValidator extends TimerExprValidator {
	
	private DueDateExpression dde;
	
	public DueDateExprValidator(DueDateExpression dde) {
		super(dde.getContainerVariables());
		this.dde = dde;
	}
	
	public ValidationMessage validate() {
		return validate(dde.getDueDateElement().getDueDate());
	}

	protected ValidationMessage getInvalidAdditionExprVM() {
		return ValidationMessageAdder.getInstance().createValidationMessage(dde.getDueDateElement(), ValidationMessageCode.DUEDATE_OPERANDS_TYPE_DURATION);
	}
	
	protected ValidationMessage getInvalidMultiplicationExprVM() {
        return ValidationMessageAdder.getInstance().createValidationMessage(dde.getDueDateElement(), ValidationMessageCode.DUEDATE_OPERAND_TYPE_DURATION_INTEGER);
	}
	
	protected ValidationMessage getInvalidUnaryExprVM() {
        return ValidationMessageAdder.getInstance().createValidationMessage(dde.getDueDateElement(), ValidationMessageCode.DUEDATE_INVALID_DURATION_FORMAT);
	}
	
	protected ValidationMessage getGenericInvalidTimerExprVM() {
        return ValidationMessageAdder.getInstance().createValidationMessage(dde.getDueDateElement(), ValidationMessageCode.DUEDATE_INVALID_TIMER_EXPRESSION);
	}
}