/*
 * Created on Jul 9, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation;

import java.util.List;

/**
 * The Validation Rule interface
 * 
 * @param <VO>
 *            Type of the object to validate
 * 
 * @author Vijay Silva
 */
public interface IValidationRule<VO>
{
	/**
	 * Validate the rule against the target object.
	 * 
	 * @param target
	 *            The Target object to validate.
	 * 
	 * @return The list of validation errors.
	 */
	List<ValidationMessage> validateRule(VO target);
}
