/*
 * Created on Jul 10, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.impl;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.watchpoint.studio.validation.IValidationRule;
import com.tandbergtv.watchpoint.studio.validation.IValidator;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;

/**
 * The default validator implementation which executes all specified validation rules.
 * 
 * @param <VO>
 *            The type of the object to validate
 * 
 * @author Vijay Silva
 */
public class RuleValidator<VO> implements IValidator<VO>
{
	List<IValidationRule<VO>> rules = new ArrayList<IValidationRule<VO>>();

	/**
	 * Constructor
	 */
	public RuleValidator()
	{
	}

	/**
	 * Constructor
	 * 
	 * @param rules
	 *            The list of rules associated with the validator
	 */
	public RuleValidator(List<IValidationRule<VO>> rules)
	{
		this.setRules(rules);
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.IValidator#getRules()
	 */
	public List<IValidationRule<VO>> getRules()
	{
		return this.rules;
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.IValidator#setRules(java.util.List)
	 */
	public void setRules(List<IValidationRule<VO>> validationRules)
	{
		this.rules.clear();

		if (validationRules != null)
		{
			this.rules.addAll(validationRules);
		}
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.IValidator#validate(java.lang.Object)
	 */
	public List<ValidationMessage> validate(VO target)
	{
		List<ValidationMessage> validationMessages = new ArrayList<ValidationMessage>();

		// Run all validation rules against target object and collect the validation messages.
		for (IValidationRule<VO> rule : rules)
		{
			List<ValidationMessage> ruleMessages = rule.validateRule(target);
			if (ruleMessages != null)
				validationMessages.addAll(ruleMessages);
		}

		return validationMessages;
	}
}
