/*
 * Created on Nov 12, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.model;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.NodeElementContainer;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;

/**
 * Abstract Model Class that mantains context information required when validating a top-level
 * container (Workflow Template, Node Definition).
 * 
 * @author Vijay Silva
 */
public abstract class ContainerValidationContext
{
	protected NodeElementContainer container;

	protected List<WPVariable> variables = new ArrayList<WPVariable>();

	/**
	 * Constructor.
	 * 
	 * @param container
	 *            the parent container holding this expression
	 * @param variables
	 *            the list of variables that may be used in the expression
	 */
	protected ContainerValidationContext(NodeElementContainer container,
			List<WPVariable> variables)
	{
		this.container = container;
		if (variables != null)
			this.variables.addAll(variables);
	}

	/**
	 * Get the parent container
	 * 
	 * @return The Parent Container
	 */
	public NodeElementContainer getContainer()
	{
		return this.container;
	}

	/**
	 * Get the variables that may be used by nodes in the container
	 * 
	 * @return the variables
	 */
	public List<WPVariable> getContainerVariables()
	{
		return this.variables;
	}

	/**
	 * Checks if the Container is a Workflow Template.
	 * 
	 * @return true if a template, false otherwise.
	 */
	public boolean isTemplateContainer()
	{
		return (this.container instanceof WorkflowTemplate);
	}

	/**
	 * Checks if the Container is a Node Definition.
	 * 
	 * @return true if a node definition, false otherwise.
	 */
	public boolean isNodeDefinitionContainer()
	{
		return (this.container instanceof NodeDefinition);
	}
}
