/**
 * 
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodedefinition.graph;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.Decision;
import org.jbpm.gd.jpdl.model.NodeElement;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.ui.model.MailNode;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPEndState;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.graph.NodeDefinitionGraph;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.graph.AllowedNodeTypesRule;

/**
 * Validates the types of the Nodes that are present in the Node Definition.
 * 
 * @author Imran Naqvi
 */
public class AllowedNodeDefinitionNodeTypesRule extends AllowedNodeTypesRule<NodeDefinitionGraph> {

	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.graph.AllowedNodeTypesRule#getAllowedNodeTypes()
	 */
	@Override
	protected List<Class<? extends NodeElement>> getAllowedNodeTypes() {
		List<Class<? extends NodeElement>> allowedTypes = new ArrayList<Class<? extends NodeElement>>();

		allowedTypes.add(WPEndState.class);
		allowedTypes.add(Decision.class);
		allowedTypes.add(NodeDefinition.class);
		allowedTypes.add(AutomaticTaskNode.class);
		allowedTypes.add(MailNode.class);
		allowedTypes.add(LoopNode.class);
		
		return allowedTypes;
	}

	/**
	 * In case the allowed type is a Node Definition, ensure that it is a Single-Node Node
	 * Definition.
	 * 
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.graph.AllowedNodeTypesRule#validateNodeType(org.jbpm.gd.jpdl.model.NodeElement,
	 *      java.util.List)
	 */
	@Override
	protected void validateNodeType(NodeElement node, List<ValidationMessage> messages) {
		super.validateNodeType(node, messages);

		/* Validate that if a Node Definition, must only be a Single-Node Node Definition */
		if (node instanceof NodeDefinition) {
			if (((NodeDefinition) node).getNodeType() != NodeDefinitionType.MessageNode) {
				ValidationMessageAdder.getInstance().addValidationMessage(messages, node, ValidationMessageCode.INVALID_NODE_TYPE);
			}
		}
	}
}
