/**
 * 
 */
package com.tandbergtv.watchpoint.studio.validation.rules.nodedefinition.graph;

import java.util.List;

import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.graph.GraphNodeDegreeRule;

import edu.uci.ics.jung.graph.Vertex;

/**
 * Validation rule that ensures that Out-Degree of every node in the node container is valid based
 * on the type of the node for a node definition. Since a node definition can have a non-StartState
 * node with no incoming transitions, this rule does not validate the Node In-Degree of the nodes.
 * 
 * @author Imran Naqvi
 * 
 */
public class NodeDefinitionNodeDegreeRule extends GraphNodeDegreeRule {

	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelementcontainer.graph.GraphNodeDegreeRule#validateNodeInDegree(edu.uci.ics.jung.graph.Vertex,
	 *      java.util.List)
	 */
	@Override
	protected void validateNodeInDegree(Vertex vertex, List<ValidationMessage> messages) {
		/* Do nothing since a node definition can have a node with no incoming transitions */
	}
}
