/*
 * Created on Nov 21, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.nodedefinition;

import java.util.HashSet;
import java.util.List;
import java.util.Set;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;

/**
 * Strategy implementation used to determine the variables present in a node definition that require
 * mapping to a variable in the Super State.
 * 
 * @author Vijay Silva
 */
public class SuperStateRequiredVariableFinder implements IRequiredVariableFinder
{
	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.nodedefinition.IRequiredVariableFinder#getRequiredVariableNames(com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition)
	 */
	public Set<String> getRequiredVariableNames(NodeDefinition nodeDefinition)
	{
		Set<String> variableNames = new HashSet<String>();

		List<WPVariable> variables = nodeDefinition.getVariables();
		if (variables != null)
		{
			for (WPVariable variable : variables)
			{
				String name = variable.getMappedName();
				if (name != null && name.trim().length() > 0)
					variableNames.add(name);
			}
		}

		return variableNames;
	}
}
