/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.core.graph.exe;

import bsh.Interpreter;
import com.tandbergtv.watchpoint.studio.debugger.core.graph.exe.ListVariableInstance2;
import java.util.Map;
import org.jbpm.JbpmException;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.context.exe.TokenVariableMap;
import org.jbpm.context.exe.VariableInstance;
import org.jbpm.context.exe.variableinstance.ByteArrayInstance;
import org.jbpm.context.exe.variableinstance.UnpersistableInstance;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;

public class ExecutionContext2
extends ExecutionContext {
    public ExecutionContext2(Token token) {
        super(token);
    }

    public ExecutionContext2(ExecutionContext other) {
        super(other);
    }

    public Object getVariable(String name) {
        return this.evaluate(name);
    }

    public void setVariable(String name, Object value) {
        if (name.length() == 0) {
            throw new JbpmException("Variable name is an empty string");
        }
        if (value != null) {
            VariableInstance variable = VariableInstance.createVariableInstance((Object)value);
            if (variable instanceof UnpersistableInstance || variable instanceof ByteArrayInstance) {
                throw new JbpmException("Variable " + name + " uses unsupported data type - " + value.getClass().getName());
            }
            if (value.toString().length() >= 4000) {
                throw new JbpmException("Variable " + name + " exceeds max length (4000)");
            }
        }
        if (ListVariableInstance2.check(name)) {
            ListVariableInstance2 list = this.getList(name);
            int index = this.index(name);
            list.set(index, value);
        } else {
            super.setVariable(name, value);
        }
    }

    private ListVariableInstance2 getList(String name) {
        String variableName = ListVariableInstance2.parseVariableName(name);
        VariableInstance v = this.getVariableInstance(variableName);
        if (!(v instanceof ListVariableInstance2)) {
            throw new IllegalArgumentException(this.token + ", " + variableName + " is not a list");
        }
        return (ListVariableInstance2)v;
    }

    private VariableInstance getVariableInstance(String name) {
        ContextInstance ci = this.token.getProcessInstance().getContextInstance();
        TokenVariableMap map = ci.getTokenVariableMap(this.token);
        if (map == null) {
            return null;
        }
        return map.getVariableInstance(name);
    }

    private Integer index(String name) {
        int start = name.indexOf("[");
        int end = name.indexOf("]");
        String s = name.substring(start + 1, end);
        Object value = this.token.getProcessInstance().getContextInstance().getVariable(s);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        return Integer.valueOf(s);
    }

    protected Object evaluate(String expression) {
        if (expression == null || expression.trim().isEmpty()) {
            throw new JbpmException("Missing variable name or expression");
        }
        Map variables = this.getContextInstance().getVariables(this.token);
        if (variables.containsKey(expression)) {
            return super.getVariable(expression);
        }
        try {
            Interpreter i = new Interpreter();
            for (Object key : variables.keySet()) {
                i.set((String)key, variables.get(key));
            }
            i.set("token", (Object)this.token);
            i.set("processInstance", (Object)this.token.getProcessInstance());
            i.set("_rootdir", (Object)System.getProperty("com.tandbergtv.cms.product.dir"));
            return i.eval(expression);
        }
        catch (Exception error) {
            throw new JbpmException("Error processing expression '" + expression + "'", (Throwable)error);
        }
    }
}

