/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.model;

import com.tandbergtv.watchpoint.studio.debugger.model.JpdlDebugElement;
import com.tandbergtv.watchpoint.studio.debugger.model.JpdlStackFrame;
import com.tandbergtv.watchpoint.studio.debugger.model.JpdlThread;
import com.tandbergtv.watchpoint.studio.debugger.model.JpdlValue;
import com.tandbergtv.watchpoint.studio.debugger.model.JpdlVariable;
import com.tandbergtv.watchpoint.studio.debugger.model.NodeBreakpoint;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;

public class JpdlDebugTarget
extends JpdlDebugElement
implements IDebugTarget {
    private static JpdlDebugTarget instance;
    private IProcess fProcess;
    private ILaunch fLaunch;
    private String fName;
    private Socket fRequestSocket;
    private PrintWriter fRequestWriter;
    private BufferedReader fRequestReader;
    private Socket fEventSocket;
    private BufferedReader fEventReader;
    private boolean fSuspended = true;
    private boolean fTerminated = false;
    private JpdlThread fThread;
    private IThread[] fThreads;
    private EventDispatchJob fEventDispatch;

    private JpdlDebugTarget(ILaunch launch, IProcess process, int requestPort, int eventPort) throws CoreException {
        super(null);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.fLaunch = launch;
        this.fTarget = this;
        this.fProcess = process;
        try {
            this.fRequestSocket = new Socket("localhost", requestPort);
            this.fRequestWriter = new PrintWriter(this.fRequestSocket.getOutputStream());
            this.fRequestReader = new BufferedReader(new InputStreamReader(this.fRequestSocket.getInputStream()));
            this.fEventSocket = new Socket("localhost", eventPort);
            this.fEventReader = new BufferedReader(new InputStreamReader(this.fEventSocket.getInputStream()));
        }
        catch (UnknownHostException e) {
            this.abort("Unable to connect to Runtime", e);
        }
        catch (IOException e) {
            this.abort("Unable to connect to Runtime", e);
        }
        this.fThread = new JpdlThread(this);
        this.fThreads = new IThread[]{this.fThread};
        this.fEventDispatch = new EventDispatchJob();
        this.fEventDispatch.schedule();
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    public IThread[] getThreads() throws DebugException {
        return this.fThreads;
    }

    public boolean hasThreads() throws DebugException {
        return true;
    }

    public String getName() {
        if (this.fName == null) {
            try {
                this.fName = this.getLaunch().getLaunchConfiguration().getAttribute("com.tandberg.watchpoint.studio.template", "Runtime Program");
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return this.fName;
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        if (breakpoint.getModelIdentifier().equals("com.tandbergtv.watchpoint.studio.debugger.jpdl")) {
            try {
                IMarker marker;
                String program = this.getLaunch().getLaunchConfiguration().getAttribute("com.tandberg.watchpoint.studio.template", null);
                if (program != null && (marker = breakpoint.getMarker()) != null) {
                    Path p = new Path(program);
                    return marker.getResource().getFullPath().equals((Object)p);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public IDebugTarget getDebugTarget() {
        return this;
    }

    @Override
    public ILaunch getLaunch() {
        return this.fLaunch;
    }

    public boolean canTerminate() {
        return this.getProcess().canTerminate();
    }

    public boolean isTerminated() {
        return this.getProcess().isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() throws DebugException {
        Socket socket = this.fRequestSocket;
        synchronized (socket) {
            this.fRequestWriter.println("exit");
            this.fRequestWriter.flush();
        }
    }

    public boolean canResume() {
        return !this.isTerminated() && this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isTerminated() && !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    public void resume() throws DebugException {
        this.sendRequest("resume");
    }

    private void resumed(int detail) {
        this.fSuspended = false;
        this.fThread.fireResumeEvent(detail);
    }

    private void suspended(int detail) {
        this.fSuspended = true;
        this.fThread.fireSuspendEvent(detail);
    }

    public void suspend() throws DebugException {
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled()) {
                    NodeBreakpoint nodeBreakpoint = (NodeBreakpoint)breakpoint;
                    try {
                        this.sendRequest("set " + nodeBreakpoint.serializeNodeName());
                    }
                    catch (CoreException coreException) {}
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                this.sendRequest("clear " + ((NodeBreakpoint)breakpoint).getNodeName());
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled()) {
                    this.breakpointAdded(breakpoint);
                } else {
                    this.breakpointRemoved(breakpoint, null);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public boolean canDisconnect() {
        return false;
    }

    public void disconnect() throws DebugException {
    }

    public boolean isDisconnected() {
        return false;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    private void started() {
        this.fireCreationEvent();
        this.installDeferredBreakpoints();
        try {
            this.resume();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
    }

    private void installDeferredBreakpoints() {
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("com.tandbergtv.watchpoint.studio.debugger.jpdl");
        int i = 0;
        while (i < breakpoints.length) {
            this.breakpointAdded(breakpoints[i]);
            ++i;
        }
    }

    private void terminated() {
        this.fTerminated = true;
        this.fSuspended = false;
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        this.fireTerminateEvent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IStackFrame[] getStackFrames() throws DebugException {
        Socket socket = this.fRequestSocket;
        synchronized (socket) {
            this.fRequestWriter.println("stack");
            this.fRequestWriter.flush();
            try {
                String framesData = this.fRequestReader.readLine();
                if (framesData != null) {
                    String[] frames = framesData.split("#");
                    IStackFrame[] theFrames = new IStackFrame[frames.length];
                    int i = 0;
                    while (i < frames.length) {
                        String data = frames[i];
                        theFrames[frames.length - i - 1] = new JpdlStackFrame(this.fThread, data, i);
                        ++i;
                    }
                    return theFrames;
                }
            }
            catch (IOException e) {
                this.abort("Unable to retrieve stack frames", e);
            }
        }
        return new IStackFrame[0];
    }

    protected void step() throws DebugException {
        this.sendRequest("step");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IValue getVariableValue(JpdlVariable variable) throws DebugException {
        Socket socket = this.fRequestSocket;
        synchronized (socket) {
            this.fRequestWriter.println("var " + variable.getName());
            this.fRequestWriter.flush();
            try {
                String[] value = this.fRequestReader.readLine().split("\\|");
                return new JpdlValue(this, value[0], value[1]);
            }
            catch (IOException e) {
                this.abort(MessageFormat.format("Unable to retrieve value for variable {0}", variable.getName()), e);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(String request) throws DebugException {
        Socket socket = this.fRequestSocket;
        synchronized (socket) {
            this.fRequestWriter.println(request);
            this.fRequestWriter.flush();
            try {
                String string = this.fRequestReader.readLine();
            }
            catch (IOException e) {
                this.abort("Request failed: " + request, e);
            }
        }
    }

    private void breakpointHit(String event) {
        int lastSpace = event.lastIndexOf(32);
        if (lastSpace > 0) {
            String nodeName = event.substring(lastSpace + 1).trim();
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("com.tandbergtv.watchpoint.studio.debugger.jpdl");
            int i = 0;
            while (i < breakpoints.length) {
                NodeBreakpoint nodeBreakpoint;
                IBreakpoint breakpoint = breakpoints[i];
                if (this.supportsBreakpoint(breakpoint) && breakpoint instanceof NodeBreakpoint && (nodeBreakpoint = (NodeBreakpoint)breakpoint).getNodeName().equals(nodeName)) {
                    this.fThread.setBreakpoints(new IBreakpoint[]{breakpoint});
                    break;
                }
                ++i;
            }
        }
        this.suspended(16);
    }

    public static IDebugTarget getInstance() {
        return instance;
    }

    public static IDebugTarget getNewInstance(ILaunch launch, IProcess process, int commandPort, int eventPort) throws CoreException {
        instance = new JpdlDebugTarget(launch, process, commandPort, eventPort);
        return instance;
    }

    class EventDispatchJob
    extends Job {
        public EventDispatchJob() {
            super("Jpdl Event Dispatch");
            this.setSystem(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            String event = "";
            while (!JpdlDebugTarget.this.isTerminated() && event != null) {
                try {
                    event = JpdlDebugTarget.this.fEventReader.readLine();
                    if (event == null) continue;
                    JpdlDebugTarget.this.fThread.setBreakpoints(null);
                    JpdlDebugTarget.this.fThread.setStepping(false);
                    if (event.equals("started")) {
                        JpdlDebugTarget.this.started();
                        continue;
                    }
                    if (event.equals("terminated")) {
                        JpdlDebugTarget.this.terminated();
                        continue;
                    }
                    if (event.startsWith("resumed")) {
                        if (event.endsWith("step")) {
                            JpdlDebugTarget.this.fThread.setStepping(true);
                            JpdlDebugTarget.this.resumed(2);
                            continue;
                        }
                        if (!event.endsWith("client")) continue;
                        JpdlDebugTarget.this.resumed(32);
                        continue;
                    }
                    if (!event.startsWith("suspended")) continue;
                    if (event.endsWith("client")) {
                        JpdlDebugTarget.this.suspended(32);
                        continue;
                    }
                    if (event.endsWith("step")) {
                        JpdlDebugTarget.this.suspended(8);
                        continue;
                    }
                    if (event.indexOf("breakpoint") < 0) continue;
                    JpdlDebugTarget.this.breakpointHit(event);
                }
                catch (IOException e) {
                    JpdlDebugTarget.this.terminated();
                }
            }
            return Status.OK_STATUS;
        }
    }
}

