/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.debug;

import com.tandbergtv.watchpoint.studio.debugger.runtime.debug.Commands;
import com.tandbergtv.workflow.core.CustomToken;
import com.tandbergtv.workflow.core.WorkflowProcess;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ActionHandler;
import org.jbpm.graph.def.Node;
import org.jbpm.graph.def.Transition;
import org.jbpm.graph.exe.ExecutionContext;

public class Breakpoint
implements ActionHandler {
    private static final Logger logger = Logger.getLogger(Breakpoint.class);
    private static final long serialVersionUID = 1L;

    public void execute(ExecutionContext context) throws Exception {
        Transition t = context.getTransition();
        CustomToken token = (CustomToken)context.getToken();
        Node node = token.getCurrentNode();
        logger.debug((Object)(token + " trying to stop at " + node.getName()));
        try {
            if (t == null) {
                return;
            }
            WorkflowProcess process = token.getProcessInstance();
            Commands.removeBreakpoint(process, node);
            Commands.suspend(process);
            logger.info((Object)(token + " hit breakpoint at " + node.getName()));
        }
        catch (Throwable e) {
            logger.warn((Object)(token + " problem during breakpoint"), e);
        }
    }
}

