/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.interpreterwrapper;

import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.runtime.RuntimeLauncher;
import com.tandbergtv.watchpoint.studio.debugger.runtime.exe.Lifecycle;
import com.tandbergtv.watchpoint.studio.debugger.runtime.parser.RuntimeTemplateParser;
import com.tandbergtv.watchpoint.studio.debugger.runtime.template.JPDLParser;
import com.tandbergtv.watchpoint.studio.interpreterwrapper.CommandPortListener;
import com.tandbergtv.watchpoint.studio.interpreterwrapper.EventDispatcher;
import com.tandbergtv.watchpoint.studio.interpreterwrapper.EventListener;
import com.tandbergtv.watchpoint.studio.interpreterwrapper.InterpreterCommandLineParser;
import com.tandbergtv.watchpoint.studio.interpreterwrapper.RuntimeCommandFacade;
import jargs.gnu.CmdLineParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jbpm.graph.def.ProcessDefinition;

public class InterpreterWrapperServer {
    private Integer commandPort;
    private Integer eventPort;
    private String templateFile;
    private String configFile;
    private String presentationTemplateFile;
    private static final Logger logger = Logger.getLogger(InterpreterWrapperServer.class);

    public InterpreterWrapperServer(Integer commandPort, Integer eventPort, String templateFile, String presentationTemplateFile, String configFile) {
        this.commandPort = commandPort;
        this.eventPort = eventPort;
        this.templateFile = templateFile;
        this.presentationTemplateFile = presentationTemplateFile;
        this.configFile = configFile;
    }

    public static void main(String[] args) {
        Object[] parsedArgs = InterpreterWrapperServer.readArgs(args);
        InterpreterWrapperServer intepreter = new InterpreterWrapperServer((Integer)parsedArgs[0], (Integer)parsedArgs[1], parsedArgs[2].toString(), parsedArgs[3].toString(), parsedArgs[4].toString());
        intepreter.start();
    }

    private static Object[] readArgs(String[] args) {
        InterpreterCommandLineParser parser = new InterpreterCommandLineParser();
        CmdLineParser.Option commandPortOption = parser.addHelp(parser.addIntegerOption('c', "commandPort"), "The port number to listen for commands issued from remote debuggers.");
        CmdLineParser.Option eventPortOption = parser.addHelp(parser.addIntegerOption('e', "eventPort"), "The port number opened to send debug events to clients connected.");
        CmdLineParser.Option templateFileOption = parser.addHelp(parser.addStringOption('t', "templateFile"), "The template file to be processed.");
        CmdLineParser.Option presentationTemplateFileOption = parser.addHelp(parser.addStringOption('p', "presentationTemplateFile"), "The template file to used by the plugin, usually a file that is not named like 'processdefinition.xml'.");
        CmdLineParser.Option configFileOption = parser.addHelp(parser.addStringOption('o', "configFile"), "The config file with simulation data to be used.");
        try {
            parser.parse(args);
            Object[] result = new Object[]{parser.getOptionValue(commandPortOption), parser.getOptionValue(eventPortOption), parser.getOptionValue(templateFileOption), parser.getOptionValue(presentationTemplateFileOption), parser.getOptionValue(configFileOption)};
            if (result[0] == null || result[1] == null || result[2] == null || result[3] == null || result[4] == null) {
                throw new IllegalStateException();
            }
            return result;
        }
        catch (IllegalStateException e) {
            InterpreterWrapperServer.treatParserException(parser);
        }
        catch (CmdLineParser.OptionException e) {
            InterpreterWrapperServer.treatParserException(parser);
        }
        return null;
    }

    private static void treatParserException(InterpreterCommandLineParser parser) {
        parser.printUsage();
        System.exit(-1);
    }

    private static void treatException(String message) {
        System.err.println(message);
        System.exit(-1);
    }

    private void start() {
        try {
            ServerSocket commandServerSocket = new ServerSocket(this.commandPort);
            ServerSocket eventServerSocket = new ServerSocket(this.eventPort);
            EventListener eventListener = new EventListener(eventServerSocket);
            EventDispatcher dispatcher = new EventDispatcher(eventListener);
            new Thread((Runnable)eventListener, "event-listener").start();
            logger.debug((Object)("Event listener started at port " + this.eventPort));
            this.startRuntime();
            logger.debug((Object)"Runtime started");
            RuntimeCommandFacade runtimeFacade = new RuntimeCommandFacade(this.presentationTemplateFile, dispatcher);
            CommandPortListener commandReceiver = new CommandPortListener(commandServerSocket, runtimeFacade);
            new Thread((Runnable)commandReceiver, "command-listener").start();
            logger.debug((Object)("Command listener started at port " + this.commandPort));
        }
        catch (IOException e) {
            InterpreterWrapperServer.treatException("Could not listen on ports: " + this.commandPort + " or " + this.eventPort);
        }
        catch (InterruptedException e) {
            InterpreterWrapperServer.treatException(e.getMessage());
        }
        catch (Exception e) {
            InterpreterWrapperServer.treatException(e.getMessage());
        }
    }

    private ProcessDefinition startRuntime() throws InterruptedException, FileNotFoundException, Exception {
        Lifecycle.start();
        Thread.sleep(2000L);
        ProcessDefinition template = new JPDLParser(this.templateFile).readProcessDefinition();
        Map<String, NodeSimulationConfig> configs = RuntimeTemplateParser.parse(this.configFile, template);
        new RuntimeLauncher(template, configs, new File(this.configFile).getParent()).startSimulation();
        return template;
    }
}

