/**
 * ExtendedJpdlXmlReader.java
 * Created Aug 19, 2010
 */
package com.tandbergtv.watchpoint.studio.debugger.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import org.dom4j.Element;
import org.jbpm.graph.def.Transition;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Problem;
import org.xml.sax.InputSource;

/**
 * Parses templates that are in the modified JPDL format
 * 
 * @author Sahil Verma
 */
public class JpdlXmlReader2 extends JpdlXmlReader {

	private static final long serialVersionUID = -1967585018835597672L;
	
	protected Collection<JpdlXmlReader2> extensions;
	
	public JpdlXmlReader2() {
		this(null);
	}

	/**
	 * Creates a reader
	 * 
	 * @param stream
	 */
	public JpdlXmlReader2(InputStream stream) {
		super(new InputSource(stream));
	    unresolvedTransitionDestinations = new ArrayList<Transition>();
	    unresolvedActionReferences = new ArrayList<Object[]>();
	    problems = new ArrayList<Problem>();
	    extensions = new ArrayList<JpdlXmlReader2>();
	}
	
	/* (non-Javadoc)
	 * @see org.jbpm.jpdl.xml.JpdlXmlReader#readVariableAccesses(org.dom4j.Element)
	 */
	@Override
	public List<?> readVariableAccesses(Element element) {
		List<VariableAccess2> variables = new ArrayList<VariableAccess2>();
		Iterator<?> i = element.elementIterator("variable");
		while (i.hasNext()) {
			Element e = (Element)i.next();
			String name = e.attributeValue("name");
			String access = e.attributeValue("access", "read,write,required");
			String mappedName = e.attributeValue("mapped-name");
			String type = e.attributeValue("type", DataType.STRING.toString());
			
			try {
				DataType datatype = DataType.valueOf(type); 
				
				variables.add(new VariableAccess2(name, access, mappedName, datatype));
			} catch (IllegalArgumentException e1) {
				addError("Variable " + name + " has invalid type (" + type + ") - " + e1.getMessage(), e1);
			} 
		}
		
		return variables;
	}
}
