package com.tandbergtv.watchpoint.studio.debugger.ui;

import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Widget;

import com.tandbergtv.watchpoint.studio.debugger.model.NodeSimulationConfig;
import com.tandbergtv.watchpoint.studio.debugger.model.SimulationType;

public class MailNodeSimulationComposite extends AbstractNodeSimulationComposite {
	
	public MailNodeSimulationComposite(Composite parent, NodeSimulationConfig node) {
		super(parent, node);
	}

	@Override
	protected void createAdditionalControls(Composite parent) {
	}
	
	@Override
	public void load(NodeSimulationConfig nodeSimulationConfig) {
		super.load(nodeSimulationConfig);
	}
	
	@Override
	protected SimulationType[] getSimulationTypes() {
		return new SimulationType[] {SimulationType.SKIP_NODE, SimulationType.EXECUTE};
	}

	/**
	 * 		Notifies when a widget is selected. Subclasses may override.
	 */
	@Override
	public void widgetSelected(SelectionEvent e) {
		Widget widget = (Widget) e.getSource();
		if (SimulationType.SKIP_NODE.equals(widget.getData())) {
			Button btn = (Button) widget;
			if (btn.getSelection()) {
				nodeSimulationConfig.setSimulationType(SimulationType.SKIP_NODE);
			}
			fireSimulationModifiedEvent(nodeSimulationConfig);
		} else if (SimulationType.EXECUTE.equals(widget.getData())) { 
			Button btn = (Button) widget;
			if (btn.getSelection()) {
				nodeSimulationConfig.setSimulationType(SimulationType.EXECUTE);
			}
			fireSimulationModifiedEvent(nodeSimulationConfig);
		} 
	}

}
