package com.tandbergtv.watchpoint.studio.interpreterwrapper;

import com.tandbergtv.watchpoint.studio.debugger.util.Base64Encoder;


public class CommandProtocol {

    private IRuntimeCommandFacade runtimeFacade;
    
    public CommandProtocol(IRuntimeCommandFacade runtimeFacade) {
        this.runtimeFacade = runtimeFacade;
    }

    public String processCommand(String command) {
        String result = "ok";
        if (command == null) {
            return result; 
        }
        
        String[] commandParams = command.split(" ");

        if (command.startsWith("clear")) {
            runtimeFacade.clear(deserializeNodeName(commandParams[commandParams.length - 1]));
        } else if (command.startsWith("exit")) {
            result = "bye.";
        } else if (command.startsWith("resume")) {
            runtimeFacade.resume();
        } else if (command.startsWith("set")) {
            runtimeFacade.set(deserializeNodeName(commandParams[commandParams.length - 1]));
        } else if (command.startsWith("suspend")) {
            runtimeFacade.suspend();
        } else if (command.startsWith("stack")) {
            result = runtimeFacade.getStack();
        } else if (command.startsWith("var")) {
            result = runtimeFacade.getVar(commandParams[commandParams.length - 1]);
        }
        return result;
    }

    private String deserializeNodeName(String nodeName) {
        return Base64Encoder.decode(nodeName);
    }
}
