package com.tandbergtv.watchpoint.studio.builder.resolution.template;

import org.eclipse.core.resources.IResource;
import org.jbpm.gd.jpdl.model.NodeElement;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.NodeGroup;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.ui.sync.template.UpdateTemplateSuperStateCommand;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class SuperStateOutdatedResolution extends WatchpointStudioTemplateResolution {

    public SuperStateOutdatedResolution(IResource resource, Object element, Object message) {
        super(resource, element, message);
    }

    protected String getSystemID(NodeDefinition node) {
		String uid = null;
		NodeGroup group = (NodeGroup) node.getNode();
		for (NodeElement element : group.getNodeElements()) {
			if (element instanceof NodeDefinition) {
				NodeDefinition nd = (NodeDefinition) element;
				if (nd.getUid() != null) {
					uid = Utility.getSystemIDByMessageUID(nd.getUid());
					break;
				}
			}
		}
		return uid;
	}
	
    @Override
    public String getLabel() {
        return (String) message;
    }

    @Override
    public void run() {
		try {
			WorkflowTemplate template = getTemplate();
			
			IResourceTypeService service = ServiceFactory.createFactory().createResourceTypeService();
			
			NodeDefinition superState = (NodeDefinition) getNodeElementByName(template, getElement().toString());
			String systemID = getSystemID(superState);
			
			ResourceType resourceType = service.getResourceTypeBySystemId(systemID);
			
			NodeDefinitionDTO remoteNode = null;
			for (NodeDefinitionDTO node : resourceType.getNodes()) {
				if (node.getType().equals(NodeDefinitionType.SuperState)) {
					if (node.getName() != null && node.getName().equals(superState.getDefinitionName())) {
						remoteNode = node;
						break;
					}
				}
			}
			UpdateTemplateSuperStateCommand command = new UpdateTemplateSuperStateCommand(superState, remoteNode);
			command.execute();

			saveTemplate();
		} catch (Exception e) {
			Utility.reportError("Error while updating SuperState node.", e);			
		}
	}
}
