/*
 * Created on Jun 25, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dataaccess.jpa;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import javax.persistence.Query;

import com.tandbergtv.watchpoint.studio.dataaccess.ProtectionKeyDAI;
import com.tandbergtv.watchpoint.studio.dto.ProtectionKey;

/**
 * The JPA Data Access Implementation for the ProtectionKey entity.
 * 
 * @author Vijay Silva
 */
public class ProtectionKeyPDAO extends PersistenceDAO<ProtectionKey, Long> implements
		ProtectionKeyDAI
{
	/**
	 * Constructor
	 * 
	 * @param persistenceContext
	 *            The Persistence Context to use for data operations.
	 */
	public ProtectionKeyPDAO(JPAPersistenceContext persistenceContext)
	{
		super(ProtectionKey.class, persistenceContext);
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.dataaccess.ProtectionKeyDAI#findByNames(java.util.Set)
	 */
	@SuppressWarnings("unchecked")
	public List<ProtectionKey> findByNames(Set<String> names)
	{
		if (names == null || names.size() == 0)
			return new ArrayList<ProtectionKey>();

		// Build the Query String
		StringBuilder queryBuf = new StringBuilder();
		queryBuf.append("SELECT NEW com.tandbergtv.watchpoint.studio.dto.ProtectionKey(pk.id, pk.name) ");
		queryBuf.append(this.getFromClause()).append(" pk ");
		queryBuf.append("WHERE pk.name IN ( ");

		boolean first = true;
		for (String name : names)
		{
			if (name == null || name.trim().length() == 0)
				continue;

			if (!first)
				queryBuf.append(", ");
			else
				first = false;

			queryBuf.append("'");
			queryBuf.append(name);
			queryBuf.append("'");
		}

		queryBuf.append(" )");

		// Create and execute the query
		Query query = this.getEntityManager().createQuery(queryBuf.toString());
		return query.getResultList();
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.dataaccess.ProtectionKeyDAI#findByName(java.lang.String)
	 */
	public ProtectionKey findByName(String name)
	{
		String queryName = "ProtectionKey.ByName";
		Query query = this.getEntityManager().createNamedQuery(queryName);
		query.setParameter("name", name);

		ProtectionKey result = null;
		try {
			result = (ProtectionKey) query.getSingleResult();
		} catch (javax.persistence.NoResultException e) {
			// No ProtectionKey found - return null
		}
		
		return result;
	}
}
