/*
 * Created on Jun 12, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dto;

/**
 * Interface indicating that the implementing object maintains version information.
 * 
 * @author Vijay Silva
 */
public interface IVersionable extends IPersistable
{
	/**
	 * Get the current version number
	 * 
	 * @return The Version Number
	 */
	int getVersion();

	/**
	 * Set the version number
	 * 
	 * @param version
	 *            The version number
	 */
	void setVersion(int version);

	/**
	 * Gets the dirty flag to indicate this version has been modified
	 * 
	 * @return The Dirty flag
	 */
	boolean isDirty();

	/**
	 * Sets the dirty flag
	 * 
	 * @param dirty
	 *            The Dirty flag
	 */
	void setDirty(boolean dirty);
}
