/*
 * Created on May 24, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dto;


/**
 * The ResourceGroup entity
 * 
 * @author Vijay Silva
 */
public class ResourceGroup implements IWatchPointDTO, IPersistable, IVersionable
{
	public static final String RESOURCE_GROUP_FILENAME = "plugin.xml";
	
	public static final String RESOURCE_GROUP_IMAGES_FOLDER = "images";
	
	private static final long serialVersionUID = 1752587187156740443L;

	private long id = DEFAULT_ID;

	private String name;
	
	private String description;

	private String functionalType;
	
	private String projectName;
	
	private String path;
	
	private String systemId;

	private ResourceType resourceType;

	private boolean internallyAcquired;

	private String allocationStrategyClassName;

	private ProtectionKey protectionKey;

	private byte[] imageContent;

	private String imageFileName;

	private int version;

	private boolean dirty;
	
	private boolean hasErrors;
	
	private boolean hasWarnings;

	/**
	 * Class Constructor
	 */
	public ResourceGroup()
	{
		super();
	}

	/**
	 * Gets the ResourceGroup Id
	 * 
	 * @see com.tandbergtv.watchpoint.studio.dto.IPersistable#getKey()
	 */
	public Long getKey()
	{
		return this.id;
	}

	/**
	 * @return the id
	 */
	public long getId()
	{
		return this.id;
	}

	/**
	 * @param id
	 *            the id to set
	 */
	public void setId(Long id)
	{
		this.id = id;
	}

	/**
	 * @return the description
	 */
	public String getDescription()
	{
		return this.description;
	}

	/**
	 * @param description
	 *            the description to set
	 */
	public void setDescription(String description)
	{
		this.description = description;
	}

	/**
	 * @return the allocationStrategyClassName
	 */
	public String getAllocationStrategyClassName()
	{
		return this.allocationStrategyClassName;
	}

	/**
	 * @param allocationStrategyClassName
	 *            the allocationStrategyClassName to set
	 */
	public void setAllocationStrategyClassName(String allocationStrategyClassName)
	{
		this.allocationStrategyClassName = allocationStrategyClassName;
	}

	/**
	 * @return the functionalType
	 */
	public String getFunctionalType()
	{
		return this.functionalType;
	}

	/**
	 * @param functionalType
	 *            the functionalType to set
	 */
	public void setFunctionalType(String functionalType)
	{
		this.functionalType = functionalType;
	}

	/**
	 * @return the imageContent
	 */
	@Deprecated
	public byte[] getImageContent()
	{
		return this.imageContent;
	}

	/**
	 * @param imageContent
	 *            the imageContent to set
	 */
	@Deprecated
	public void setImageContent(byte[] imageContent)
	{
		this.imageContent = imageContent;
	}

	/**
	 * @return the imageFileName
	 */
	public String getImageFileName()
	{
		return imageFileName;
	}

	/**
	 * @param imageFileName
	 *            the imageFileName to set
	 */
	public void setImageFileName(String imageFileName)
	{
		this.imageFileName = imageFileName;
	}

	/**
	 * @return the internallyAcquired
	 */
	public boolean isInternallyAcquired()
	{
		return this.internallyAcquired;
	}

	/**
	 * @param internallyAcquired
	 *            the internallyAcquired to set
	 */
	public void setInternallyAcquired(boolean internallyAcquired)
	{
		this.internallyAcquired = internallyAcquired;
	}

	/**
	 * @return the name
	 */
	public String getName()
	{
		return this.name;
	}

	/**
	 * @param name
	 *            the name to set
	 */
	public void setName(String name)
	{
		this.name = name;
	}

	/**
	 * @return the resourceType
	 */
	@Deprecated
	public ResourceType getResourceType()
	{
		return this.resourceType;
	}

	/**
	 * @param resourceType
	 *            the resourceType to set
	 */
	@Deprecated
	public void setResourceType(ResourceType resourceType)
	{
		this.resourceType = resourceType;
	}

	/**
	 * @return the protectionKey
	 */
	public ProtectionKey getProtectionKey()
	{
		return this.protectionKey;
	}

	/**
	 * @param protectionKey
	 *            the protectionKey to set
	 */
	public void setProtectionKey(ProtectionKey protectionKey)
	{
		this.protectionKey = protectionKey;
	}

	/**
	 * @return the dirty
	 */
	@Deprecated
	public boolean isDirty()
	{
		return this.dirty;
	}

	/**
	 * @param dirty
	 *            the dirty to set
	 */
	@Deprecated
	public void setDirty(boolean dirty)
	{
		this.dirty = dirty;
	}

	/**
	 * @return the version
	 */
	public int getVersion()
	{
		return this.version;
	}

	/**
	 * @param version
	 *            the version to set
	 */
	public void setVersion(int version)
	{
		this.version = version;
	}
	
	
	public String getProjectName() {
		return projectName;
	}

	public void setProjectName(String projectName) {
		this.projectName = projectName;
	}

	public String getPath() {
		return path;
	}

	public void setPath(String path) {
		this.path = path;
	}
	
	public String getSystemId() {
		return systemId;
	}

	public void setSystemId(String systemId) {
		this.systemId = systemId;
	}
	
	public boolean isHasErrors() {
		return hasErrors;
	}

	public void setHasErrors(boolean hasErrors) {
		this.hasErrors = hasErrors;
	}

	public boolean isHasWarnings() {
		return hasWarnings;
	}

	public void setHasWarnings(boolean hasWarnings) {
		this.hasWarnings = hasWarnings;
	}

	/*
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode()
	{
		if (this.id == DEFAULT_ID)
			return super.hashCode();

		return new Long(this.id).hashCode() * 7 - 847;
	}

	/**
	 * Returns true iff the object compared is a ResourceGroup whose Id is not the Default Id and is
	 * equal to the current Id.
	 * 
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj)
	{
		if (!(obj instanceof ResourceGroup))
			return false;

		ResourceGroup group = (ResourceGroup) obj;

		/* Check for the Default Id */
		if (this.id == DEFAULT_ID && group.id == DEFAULT_ID)
			return super.equals(group);

		return (this.id == group.id);
	}

	/**
	 * Creates a clone of the Resource Group.
	 * 
	 * @see java.lang.Object#clone()
	 */
	@Override
	public ResourceGroup clone()
	{
		ResourceGroup clone = null;

		try
		{
			clone = (ResourceGroup) super.clone();

			if (this.resourceType != null)
				clone.resourceType = this.resourceType.clone();

			if (this.protectionKey != null)
				clone.protectionKey = this.protectionKey.clone();

			if (this.imageContent != null)
			{
				int byteCount = this.imageContent.length;
				clone.imageContent = new byte[byteCount];
				System.arraycopy(this.imageContent, 0, clone.imageContent, 0, byteCount);
			}
		}
		catch (CloneNotSupportedException ex)
		{ // Should never happen
		}

		return clone;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString()
	{
		return this.name + " [" + this.resourceType.getSystemId() + "] - v" + this.version;
	}
}
